﻿using System.Text;

namespace Xueit.Config
{
    /// <summary>
    /// 基本设置类
    /// </summary>
    public class BaseConfigs
    {
        // 描述类实例
        private static BaseConfigInfo configinfo;

        /// <summary>
        /// 静态构造函数初始化实例
        /// </summary>
        static BaseConfigs()
        {
            configinfo = new BaseConfigInfo();
        }

        /// <summary>
        /// 返回实例信息
        /// </summary>
        /// <returns></returns>
        public static BaseConfigInfo GetBaseConfig()
        {
            return configinfo;
        }

        #region 数据库基本设置
        

        /// <summary>
        /// 返回数据库连接串
        /// </summary>
        public static string GetDBConnectString
        {
            get
            {
                return GetBaseConfig().Dbconnectstring;
            }
        }

        /// <summary>
        /// 返回数据库类型
        /// </summary>
        public static string GetDbType
        {
            get
            {
                return GetBaseConfig().Dbtype;
            }
        }

        /// <summary>
        /// 返回组合数据库连接字符串
        /// </summary>
        /// <param name="_ip">服务器IP</param>
        /// <param name="_user">登录用户名</param>
        /// <param name="_pwd">登录密码</param>
        /// <param name="_dbname">数据库名称</param>
        /// <returns></returns>
        public static string GetDBConnString(string _ip,string _user,string _pwd,string _dbname)
        {
            GetBaseConfig().dbServerip = _ip;
            GetBaseConfig().dbServerLoginName = _user;
            GetBaseConfig().dbServerLoginPassword = _pwd;
            GetBaseConfig().dbname = _dbname;
            StringBuilder linkStr = new StringBuilder();
            linkStr.AppendFormat("Data Source={0}", GetBaseConfig().dbServerip);
            linkStr.Append(";");
            linkStr.AppendFormat("Initial Catalog={0}",GetBaseConfig().dbname);
            linkStr.Append(";Integrated Security=False;");
            linkStr.AppendFormat("User={0}",GetBaseConfig().dbServerLoginName);
            linkStr.Append(";");
            linkStr.AppendFormat("Pwd={0}",GetBaseConfig().dbServerLoginPassword);

            return linkStr.ToString();
        }


        #endregion

    }
}
