﻿/*
 * 
 * 数据库反射
 * 
 */ 
using System;
using System.Collections.Generic;
using System.Web;

namespace taowaw.Data
{
    #region 前台引用
    
    /// <summary>
    /// 反射引用相关数据库空间
    /// </summary>
    public class DatabaseProvider
    {
        private DatabaseProvider()
        { }

        private static IDataProvider _instance = null;
        private static object lockHelper = new object();

        static DatabaseProvider()
        {
            GetProvider();
        }

        /// <summary>
        /// 反射前台数据库空间
        /// </summary>
        private static void GetProvider()
        {
            try
            {
                // 引用
                _instance = (IDataProvider)Activator.CreateInstance(Type.GetType(string.Format("taowaw.Data.{0}.DataProvider, taowaw.Data", "Sqlite"), false, true));
            }
            catch(Exception ex)
            {
                throw new Exception("请检查Web.config节点ConnectionString的属性providerName数据库类型是否正确，例如：SqlServer、Sqlite"+ex.Message);
            }
        }

        /// <summary>
        /// 相关数据库反射接口
        /// </summary>
        public static IDataProvider GetInstance()
        {
            if (_instance == null)
            {
                lock (lockHelper)
                {
                    if (_instance == null)
                    {
                        GetProvider();
                    }
                }
            }

            return _instance;
        }

        public static void ResetDbProvider()
        {
            _instance = null;
        }
    }

    #endregion
    
}
