﻿/*
 * 
 * 数据库操作基础接口实现
 * 
 * 
 */
using System;
using System.Collections.Generic;
using System.Web;
using System.Data;
using System.Data.SQLite;

using taowaw.Common;

namespace taowaw.Data.Sqlite
{
    /// <summary>
    /// 实现数据库外部接口
    /// 多数据库应用时，修改此文件
    /// 2009-07-12
    /// </summary>
    public partial class DataProvider : IDataProvider
    {
        #region SqlServer数据层(特殊环境用到，如：首页)

        public IDbConnection CreateConn()
        {
            return new SQLiteConnection(Utils.getConnectionStrings("SqliteConnString").Replace("@", System.Web.HttpContext.Current.Request.MapPath("/")));
        }

        public IDbConnection CreateConn(string str)
        {
            return new SQLiteConnection(str);
        }

        public IDbDataAdapter CreateDataAdapter()
        {
            return new SQLiteDataAdapter();
        }

        public IDbCommand CreateCommand()
        {
            return new SQLiteCommand();
        }

        public IDbTransaction CreateTransaction()
        {
            IDbConnection iDbConnection = CreateConn();
            IDbTransaction iDbTransaction = iDbConnection.BeginTransaction();
            return iDbTransaction;
        }

        public IDataParameter[] CreateParameter(int i)
        {
            return new SQLiteParameter[i];
        }

        public IDataParameter SqlParameters(string pname, SqlDbType ptype, int psize)
        {
            return new SQLiteParameter(pname, (DbType)ptype, psize);
        }

        public IDataParameter SqlParameters(string pname, SqlDbType ptype)
        {
            return new SQLiteParameter(pname, (DbType)ptype);
        }

        #region 使用到DbType的专用，如Sqlite
        
        public IDataParameter SqlParameters(string pname, DbType ptype, int psize)
        {
            // 返回如SqliteParameter(panme,ptype,psize)
            return new SQLiteParameter(pname, ptype, psize);
        }

        public IDataParameter SqlParameters(string pname, DbType ptype)
        {
            return new SQLiteParameter(pname, ptype);
        }

        #endregion

        public DataTable ExecuteDataTable(IDbConnection conn, CommandType cmdType, string cmdText, bool close, IDataParameter[] commandParameters)
        {
            DataTable dt = DbHelper.ExecuteDataTable(conn, cmdType, cmdText, close, commandParameters);

            return dt;
        }

        public void Close(IDbConnection conn)
        {
            DbHelper.Close(conn);
        }

        #endregion
    }
}
