﻿/*
 * 
 * 数据库操作参数类
 * 
 * 
 */
using System.Data;
using System.Data.Common;

namespace taowaw.Data
{
    /// <summary>
    /// 生成SQL语句参数类(外部直接调用)
    /// 通用
    /// 2009-07-12
    /// </summary>
    public class DbParameters
    {
        private string _iDbType="Sqlite";
        IDataParameter[] _spara = null;
        
        public DbParameters(int i)
        {
            _spara = DatabaseProvider.GetInstance().CreateParameter(i);
        }

        /// <summary>
        /// 重新设置数组大小
        /// </summary>
        /// <param name="i"></param>
        public void set(int i)
        {
            _spara = DatabaseProvider.GetInstance().CreateParameter(i);
        }

        /// <summary>
        /// 添加数据到参数数组
        /// </summary>
        /// <param name="irow">下标</param>
        /// <param name="iname">参数键</param>
        /// <param name="itype">参数类型</param>
        /// <param name="isize">参数大小，无穷大为0</param>
        /// <param name="ivalue">参数值</param>
        public void add(int irow, string iname, string itype, int isize, string ivalue)
        {
            string _DbType = _iDbType;
            if (isize != 0)
            {
                if (_DbType.ToLower() == "sqlserver")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetsType(itype), isize); //_spara[irow] = new SqlParameter(iname, itype, isize);
                else if (_DbType.ToLower() == "sqlite")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetdType(itype), isize);
            }
            else //无穷大，不设定类型的长度
            {
                if (_DbType.ToLower() == "sqlserver")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetsType(itype));
                else if (_DbType.ToLower() == "sqlite")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetdType(itype));
            }
            _spara[irow].Value = ivalue;
        }

        /// <summary>
        /// 添加数据到参数数组(重载)
        /// </summary>
        /// <param name="irow">下标</param>
        /// <param name="iname">参数键</param>
        /// <param name="itype">参数类型</param>
        /// <param name="isize">参数大小，无穷大为0</param>
        /// <param name="ivalue">参数值</param>
        public void add(int irow, string iname, string itype, int isize, int ivalue)
        {
            string _DbType = _iDbType;;
            if (isize != 0)
            {
                if (_DbType.ToLower() == "sqlserver")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetsType(itype), isize); //_spara[irow] = new SqlParameter(iname, itype, isize);
                else if (_DbType.ToLower() == "sqlite")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetdType(itype), isize);
            }
            else //无穷大，不设定类型的长度
            {
                if (_DbType.ToLower() == "sqlserver")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetsType(itype));
                else if (_DbType.ToLower() == "sqlite")
                    _spara[irow] = DatabaseProvider.GetInstance().SqlParameters(iname, GetdType(itype));
            }
            _spara[irow].Value = ivalue;
        }

        /// <summary>
        /// 返回参数数组
        /// </summary>
        /// <returns></returns>
        public IDataParameter[] Parameter()
        {
            return _spara;
        }

        /// <summary>
        /// 释放数组
        /// </summary>
        public void Dispose()
        {
            _spara = null;
        }

        public void test()
        {
            for (int i = 0; i < _spara.Length; i++)
            {
                System.Web.HttpContext.Current.Response.Write("DbType：" + _spara[i].DbType);
                System.Web.HttpContext.Current.Response.Write("<br>");
                System.Web.HttpContext.Current.Response.Write("ParameterName：" + _spara[i].ParameterName);
                System.Web.HttpContext.Current.Response.Write("<br>");
                System.Web.HttpContext.Current.Response.Write("Value：" + _spara[i].Value);
                System.Web.HttpContext.Current.Response.Write("<br>");
                System.Web.HttpContext.Current.Response.Write("Direction：" + _spara[i].Direction);
                System.Web.HttpContext.Current.Response.Write("<br>=======================================================<br>");
            }
        }

        #region 接口的数据库字段类型

        /// <summary>
        /// 返回相应SqlDbType类型
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        private SqlDbType GetsType(string type)
        {
            switch (type)
            {
                case "Int":
                    return SqlDbType.Int;
                case "Money":
                    return SqlDbType.Money;
                case "NChar":
                    return SqlDbType.NChar;
                case "NText":
                    return SqlDbType.NText;
                case "NVarChar":
                    return SqlDbType.NVarChar;
                case "SmallDateTime":
                    return SqlDbType.SmallDateTime;
                case "SmallInt":
                    return SqlDbType.SmallInt;
                case "SmallMoney":
                    return SqlDbType.SmallMoney;
                case "Text":
                    return SqlDbType.Text;
                case "DateTime":
                    return SqlDbType.DateTime;
                case "Float":
                    return SqlDbType.Float;
                case "VarChar":
                    return SqlDbType.VarChar;
                case "UniqueIdentifier":
                    return SqlDbType.UniqueIdentifier;
                case "TinyInt":
                    return SqlDbType.TinyInt;
                case "Bit":
                    return SqlDbType.Bit;
                case "BigInt":
                    return SqlDbType.BigInt;
                case "Image":
                    return SqlDbType.Image;
                case "Decimal":
                    return SqlDbType.Decimal;
                case "Char":
                    return SqlDbType.Char;
                default:
                    return SqlDbType.VarChar;
            }
        }

        /// <summary>
        /// 返回相应DbType类型
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        private DbType GetdType(string type)
        {
            switch (type)
            {
                case "Int":
                    return DbType.Int32;
                case "Money":
                    return DbType.Currency;
                case "NChar":
                    return DbType.StringFixedLength;
                case "NText":
                    return DbType.String;
                case "NVarChar":
                    return DbType.String;
                case "SmallDateTime":
                    return DbType.Date;
                case "SmallInt":
                    return DbType.Int16;
                case "SmallMoney":
                    return DbType.Currency;
                case "Text":
                    return DbType.AnsiString;
                case "DateTime":
                    return DbType.DateTime;
                case "Float":
                    return DbType.Double;
                case "VarChar":
                    return DbType.AnsiString;
                case "UniqueIdentifier":
                    return DbType.Guid;
                case "TinyInt":
                    return DbType.Byte;
                case "Bit":
                    return DbType.Boolean;
                case "BigInt":
                    return DbType.Int64;
                case "Image":
                    return DbType.Binary;
                case "Decimal":
                    return DbType.Decimal;
                case "Char":
                    return DbType.AnsiStringFixedLength;
                default:
                    return DbType.AnsiString;
            }
        }

        #endregion

        #region 存储过程返回的类型
        
        /// <summary>
        /// 设置存储过程参数输出值类型
        /// </summary>
        /// <param name="irow"></param>
        /// <param name="dvalue"></param>
        public void Direction(int irow, string dvalue)
        {
            switch (dvalue)
            {
                case "Input":
                    _spara[irow].Direction = ParameterDirection.Input;
                    break;
                case "InputOutput":
                    _spara[irow].Direction = ParameterDirection.InputOutput;
                    break;
                case "Output":
                    _spara[irow].Direction = ParameterDirection.Output;
                    break;
                case "ReturnValue":
                    _spara[irow].Direction = ParameterDirection.ReturnValue;
                    break;
            }
        }

        /// <summary>
        /// 获取存储过程参数返回值(类型为obj,需转换为相应类型，如:int)
        /// </summary>
        /// <param name="irow">行数</param>
        /// <returns></returns>
        public object ReturnValueObject(int irow)
        {
            return _spara[irow].Value;
        }

        #endregion

        #region 存储过程返回的类型属性
        
        /// <summary>
        /// 存储过程参数
        /// </summary>
        public string Input
        {
            get { return "Input"; }
        }

        /// <summary>
        /// 存储过程参数
        /// </summary>
        public string InputOutput
        {
            get { return "InputOutput"; }
        }

        /// <summary>
        /// 存储过程参数
        /// </summary>
        public string Output
        {
            get { return "Output"; }
        }

        /// <summary>
        /// 存储过程参数
        /// </summary>
        public string ReturnValue
        {
            get { return "ReturnValue"; }
        }

        #endregion

        #region 参数.通过此获取相应数据库的字段类型

        public string Int
        {
            get { return "Int"; }
        }

        public string Money
        {
            get { return "Money"; }
        }

        public string Char
        {
            get { return "Char"; }
        }

        public string NChar
        {
            get { return "NChar"; }
        }

        public string NText
        {
            get { return "NText"; }
        }

        public string NVarChar
        {
            get { return "NVarChar"; }
        }

        public string SmallDateTime
        {
            get { return "SmallDateTime"; }
        }

        public string SmallInt
        {
            get { return "SmallInt"; }
        }

        public string SmallMoney
        {
            get { return "SmallMoney"; }
        }

        public string DateTime
        {
            get { return "DateTime"; }
        }

        public string Float
        {
            get { return "Float"; }
        }

        public string VarChar
        {
            get { return "VarChar"; }
        }

        public string UniqueIdentifier
        {
            get { return "UniqueIdentifier"; }
        }

        public string TinyInt
        {
            get { return "TinyInt"; }
        }

        public string Text
        {
            get { return "Text"; }
        }

        public string Bit
        {
            get { return "Bit"; }
        }

        public string BigInt
        {
            get { return "BigInt"; }
        }

        public string Image
        {
            get { return "Image"; }
        }

        public string Decimal
        {
            get { return "Decimal"; }
        }

        #endregion
    }
}
