﻿/*
 * 
 * 数据库操作基础接口
 * 
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

namespace taowaw.Data
{
    /// <summary>
    /// 数据库接口
    /// </summary>
    public interface IDataProvider
    { 
        #region 数据层接口
        /// <summary>
        /// 数据库连接对象
        /// </summary>
        /// <returns></returns>
        IDbConnection CreateConn();
        IDbConnection CreateConn(string str);
        /// <summary>
        /// 关闭数据库连接对象
        /// </summary>
        /// <param name="conn"></param>
        void Close(IDbConnection conn);
        /// <summary>
        /// 创建数据库参数(重载SqlDbType、DbType类型)
        /// </summary>
        /// <param name="i"></param>
        /// <returns></returns>
        IDataParameter[] CreateParameter(int i);
        IDataParameter SqlParameters(string pname, SqlDbType ptype, int psize);
        IDataParameter SqlParameters(string pname, SqlDbType ptype);
        IDataParameter SqlParameters(string pname, DbType ptype, int psize);
        IDataParameter SqlParameters(string pname, DbType ptype);
        /// <summary>
        /// 返回DataTable
        /// </summary>
        /// <param name="conn"></param>
        /// <param name="cmdType"></param>
        /// <param name="cmdText"></param>
        /// <param name="close"></param>
        /// <param name="commandParameters"></param>
        /// <returns></returns>
        DataTable ExecuteDataTable(IDbConnection conn, CommandType cmdType, string cmdText, bool close, IDataParameter[] commandParameters);
        /// <summary>
        /// 创建da对象
        /// </summary>
        /// <returns></returns>
        IDbDataAdapter CreateDataAdapter();
        /// <summary>
        /// 创建Command对象
        /// </summary>
        /// <returns></returns>
        IDbCommand CreateCommand();
        /// <summary>
        /// 创建事务对象
        /// </summary>
        /// <returns></returns>
        IDbTransaction CreateTransaction();
	    #endregion
    }
}
