﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	#region 状态
	switch (Request.QueryString["Status"])
	{
		case "1":
			condition.Append(Alias.Order.IsConfirmed + "=false AND " + Alias.Order.IsArchived + "=false AND " + Alias.Order.IsCanceled + "=false");
			break;
		case "2":
			condition.Append(Alias.Order.IsConfirmed + "=true AND " + Alias.Order.IsArchived + "=false AND " + Alias.Order.IsCanceled + "=false");
			break;
		case "3":
			condition.Append(Alias.Order.IsCanceled + "=true");
			break;
		case "4":
			condition.Append(Alias.Order.IsArchived + "=true");
			break;
		default:
			break;
	}
	#endregion
	
	return condition.ToString();
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>订单号</th>
			<th>下单日期</th>
			<th>订单总额</th>
			<th>订单状态</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Order" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ilghar:Record>
				<tr>
					<td><a href="view.aspx?ID=<%=InnerID%>"><%=Number%></a></td>
					<td><%=CreateTime%></td>
					<td><%=Sum%></td>
					<td>
						<%If Convert.ToBoolean(IsConfirmed)%>
							<%If Int32.Equals(IsPayed, 1)%>
								未付款
							<%ElseIf Int32.Equals(IsPayed, 2)%>
								部分付款
							<%ElseIf Int32.Equals(IsPayed, 3)%>
								已付款
							<%ElseIf Int32.Equals(IsPayed, 4)%>
								部分退款
							<%ElseIf Int32.Equals(IsPayed, 5)%>
								已退款
							<%EndIf%>
							，
							<%If Int32.Equals(IsDelivered, 1)%>
								未发货
							<%ElseIf Int32.Equals(IsDelivered, 2)%>
								部分发货
							<%ElseIf Int32.Equals(IsDelivered, 3)%>
								已发货
							<%ElseIf Int32.Equals(IsDelivered, 4)%>
								部分退货
							<%ElseIf Int32.Equals(IsDelivered, 5)%>
								已退货
							<%EndIf%>
						<%Else%>
							未受理
						<%EndIf%>
						
						<%If Convert.ToBoolean(IsArchived)%>
							，已归档
						<%EndIf%>
						
						<%If Convert.ToBoolean(IsCanceled)%>
							，已取消
						<%EndIf%>
					</td>
					<td>
						<%If Convert.ToBoolean(IsConfirmed) && !Convert.ToBoolean(IsArchived) && !Convert.ToBoolean(IsCanceled) && !Int32.Equals(IsPayed, 3)%>
							【<a id="Pay<%=InnerID%>">付款</a>】
						<%EndIf%>
						【<a href="feedback.aspx?ID=<%=InnerID%>">反馈</a>】
					</td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif" alt="首页" />
					<img src="<%=ImagePath%>pagination/previous_page_off.gif" alt="上一页" />
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif" alt="首页" /></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif" alt="上一页" /></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif" alt="下一页" />
					<img src="<%=ImagePath%>pagination/last_page_off.gif" alt="尾页" />
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif" alt="下一页" /></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif" alt="尾页" /></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>