﻿function BuildHeader()
{
	if (_page == "info_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
}	

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
			
			if (_page == "info_list")
			{
				MakeButton();
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";

	if (_page == "info_list")
	{
	    if ($("#IsRecycled")[0].selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if ($("#IsRecycled")[0].selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateInfo('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
		
	$("#ExtraButton").html(buttons);
}

//-------------------------------------------------
//Start : 信息管理
function AddInfo()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var region = $("[name=RegionID] option:selected");
	var category = $("[name=CategoryID] option:selected");
	
	var expirationTime = new Date();
	expirationTime = new Date(expirationTime.getTime() + parseInt(this.ExpirationTime.value)*24*60*60*1000);
	
	var data = "IsChecked=false&Title=" + encodeURIComponent(this.Title.value);
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	data += "&ExpirationTime=" + FormatDate(expirationTime, "YYYY-MM-DD hh:mm:ss.SSS");
	data += "&PageID=" + FormatDate(new Date(), "YYYYMMDDhhmmssSSS");
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Info&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddInfo_GetInnerID();
		}
	});
	
	return false;	
}

function AddInfo_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Info&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddInfo_SetPageID();
		}
	});
}

function AddInfo_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Info&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		Info_UploadPicture();
		}
	});
}

function EditInfo()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var region = $("[name=RegionID] option:selected");
	var category = $("[name=CategoryID] option:selected");

	var data = "IsChecked=false&Title=" + encodeURIComponent(this.Title.value);
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&QQ=" + encodeURIComponent(this.QQ.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Info&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Info_UploadPicture();
		}
	});
	
	return false;	
}

function Info_UploadPicture()
{
    if (!_uploadPicture)
    {
        Info_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Info&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Info_UploadThumbnail();
    	}
    });
}

function Info_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Info&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateInfo(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateInfo(action, id);}, this);
		else
			UpdateInfo(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Info&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
			}
		});
	}
}
//End : 信息管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "info_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddInfo);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "info_edit")
	{		
		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditInfo);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "info_list")
	{
		MakeButton();

		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
}
Init(true);