﻿function BuildHeader()
{
	if (_page == "movie_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Type=" + $("#Type").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "movie_url_list")
		return BuildAjaxPath(true) + "?MovieID=" + _movieInnerID + ($("[name=CategoryID]")[0].selectedIndex == 0 ? "" : "&CategoryID=" + $("[name=CategoryID]").val());
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "person_select")
		return BuildAjaxPath(true) + "?RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
}	

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
		    alert(request.responseText);
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();
		}
	});
}

function MakeButton()
{
	var buttons = "";

	if (_page == "movie_list")
	{
	    if ($("#IsRecycled")[0].selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if ($("#IsRecycled")[0].selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateMovie('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx";
	else if (type == "Actor" || type == "Director")
		path = "../person/select.aspx?Type=" + type;

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' tagName='" + tag.Name + "' tagPageGenerate='" + tag.PageGenerate + "' tagPageTemplate='" + tag.PageTemplate + "'' tagPageID='" + tag.PageID + "'' tagPageExtension='" + tag.PageExtension + "' /><label for='" + tag.ID + "'>" + tag.Name + "</label>");	
}

function SelectPerson(person, checked, type)
{
	var persons = $("[name=" + type + "]");
	for (var i = 0; i < persons.length; i++)
	{
		if (persons[i].id == person.ID)
		{
			persons[i].checked = checked;
			return;
		}
	}
	
	var personContainer = $("#" + type + "Div");
	var br = "";
	if (persons.length > 0 && persons.length % 5 == 0) br = "<br />";
	personContainer.html(personContainer.html() + br + "<input type='checkbox' checked='checked' name='" + type + "' id='" + person.ID + "' value='" + person.Name + "' PageGenerate='" + person.PageGenerate + "' PageTemplate='" + person.PageTemplate + "'' PageID='" + person.PageID + "'' PageExtension='" + person.PageExtension + "' /><label for='" + person.ID + "'>" + person.Name + "</label>");
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareActor()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var actors = $("[name=Actor]");
	
	if (typeof(_actorIndex) != "undefined")
	{
	    _actorIndex = 0;
	}
	else
	{
	    _actorAddIndex = 0;
	    _actorDeleteIndex = 0;
	    _actorAddList.length = 0;
	    _actorDeleteList.length = 0;
    	    	
	    actors.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _actors.length; j++)
			    {
				    if (this.id == _actors[j] || this.id == _actors[j].ID)
					    break;
			    }
			    if (j >= _actors.length)
				    _actorAddList[_actorAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _actors.length; j++)
			    {
				    if (this.id == _actors[j] || this.id == _actors[j].ID)
				    {
					    _actorDeleteList[_actorDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_actors.length = 0;
	actors.each(function()
	{
		if (!this.checked)
		    return false;

		_actors[_actors.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareDirector()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var directors = $("[name=Director]");
	
	if (typeof(_directorIndex) != "undefined")
	{
	    _directorIndex = 0;
	}
	else
	{
	    _directorAddIndex = 0;
	    _directorDeleteIndex = 0;
	    _directorAddList.length = 0;
	    _directorDeleteList.length = 0;
    	    	
	    directors.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _directors.length; j++)
			    {
				    if (this.id == _directors[j] || this.id == _directors[j].ID)
					    break;
			    }
			    if (j >= _directors.length)
				    _directorAddList[_directorAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _directors.length; j++)
			    {
				    if (this.id == _directors[j] || this.id == _directors[j].ID)
				    {
					    _directorDeleteList[_directorDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_directors.length = 0;
	directors.each(function()
	{
		if (!this.checked)
		    return false;

		_directors[_directors.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 电影管理
function AddMovie()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Premiere.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.Premiere.value))
		{
		    Alert(_lang_premiere_incorrect, function(){this.Premiere.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	_urlIndex = 0;
	_urlTable = $("#UrlTable tbody")[0];

	var tag = PrepareTag();
	var actor = PrepareActor();
	var director = PrepareDirector();

	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("RegionID", region.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&Premiere=" + this.Premiere.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&ActorNames=" + encodeURIComponent(actor.Names);
	data += "&ActorPageGenerates=" + encodeURIComponent(actor.PageGenerates);
	data += "&ActorPageTemplates=" + encodeURIComponent(actor.PageTemplates);
	data += "&ActorPageIDs=" + encodeURIComponent(actor.PageIDs);
	data += "&ActorPageExtensions=" + encodeURIComponent(actor.PageExtensions);
	data += "&DirectorNames=" + encodeURIComponent(director.Names);
	data += "&DirectorPageGenerates=" + encodeURIComponent(director.PageGenerates);
	data += "&DirectorPageTemplates=" + encodeURIComponent(director.PageTemplates);
	data += "&DirectorPageIDs=" + encodeURIComponent(director.PageIDs);
	data += "&DirectorPageExtensions=" + encodeURIComponent(director.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddMovie_GetInnerID();
		}
	});
	
	return false;	
}

function AddMovie_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddMovie_SetPageID();
		}
	});
}

function AddMovie_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddMovie_AddTag();
		}
	});
}

function AddMovie_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddMovie_AddActor();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddTag();
		}
	});
}

function AddMovie_AddActor()
{
	if (_actorIndex >= _actors.length)
	{
		AddMovie_AddDirector();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&ActorID=" + _actors[_actorIndex];
	
	_actorIndex++;

    SetStatusMessage(_lang_adding_actor);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Actor&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddActor();
		}
	});
}

function AddMovie_AddDirector()
{
	if (_directorIndex >= _directors.length)
	{
		AddMovie_AddUrl();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&DirectorID=" + _directors[_directorIndex];
	
	_directorIndex++;

    SetStatusMessage(_lang_adding_director);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Director&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddDirector();
		}
	});
}

function AddMovie_AddUrl()
{
	if (_urlIndex >= _urlTable.rows.length)
	{
		Movie_UploadPicture();
		return;
	}
	
	var urlCategoryID = _urlTable.rows[_urlIndex].cells[0].childNodes[0].value;
	var name = _urlTable.rows[_urlIndex].cells[1].childNodes[0].value;
	var url = _urlTable.rows[_urlIndex].cells[2].childNodes[0].value;
	var playerID = _urlTable.rows[_urlIndex].cells[3].childNodes[0].value;
	
	_urlIndex++;
	if (name == "" || url == "")
	{
		AddMovie_AddUrl();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&CategoryID=" + urlCategoryID;
	data += "&Name=" + encodeURIComponent(name);
	data += "&Url=" + encodeURIComponent(url);
	data += "&PlayerID=" + playerID;
	
    SetStatusMessage(_lang_adding_url);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMovie_AddUrl();
		}
	});
}

function EditMovie()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	if (this.Premiere.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.Premiere.value))
		{
		    Alert(_lang_premiere_incorrect, function(){this.Premiere.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var actor = PrepareActor();
	var director = PrepareDirector();
	
	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&Premiere=" + this.Premiere.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&ActorNames=" + encodeURIComponent(actor.Names);
	data += "&ActorPageGenerates=" + encodeURIComponent(actor.PageGenerates);
	data += "&ActorPageTemplates=" + encodeURIComponent(actor.PageTemplates);
	data += "&ActorPageIDs=" + encodeURIComponent(actor.PageIDs);
	data += "&ActorPageExtensions=" + encodeURIComponent(actor.PageExtensions);
	data += "&DirectorNames=" + encodeURIComponent(director.Names);
	data += "&DirectorPageGenerates=" + encodeURIComponent(director.PageGenerates);
	data += "&DirectorPageTemplates=" + encodeURIComponent(director.PageTemplates);
	data += "&DirectorPageIDs=" + encodeURIComponent(director.PageIDs);
	data += "&DirectorPageExtensions=" + encodeURIComponent(director.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteTag();
		}
	});

	return false;
}

function EditMovie_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditMovie_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Tag&Operation=Delete&MovieID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteTag();
		}
	});
}

function EditMovie_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditMovie_DeleteActor();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddTag();
		}
	});
}

function EditMovie_DeleteActor()
{
	if (_actorDeleteIndex >= _actorDeleteList.length)
	{
		EditMovie_AddActor();
		return;
	}

	SetStatusMessage(_lang_modifying_actor);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Actor&Operation=Delete&MovieID=" + _guid + "&ActorID=" + _actorDeleteList[_actorDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteActor();
		}
	});
}

function EditMovie_AddActor()
{
	if (_actorAddIndex >= _actorAddList.length)
	{
        EditMovie_DeleteDirector();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&ActorID=" + _actorAddList[_actorAddIndex];
	
	_actorAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Actor&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddActor();
		}
	});
}

function EditMovie_DeleteDirector()
{
	if (_directorDeleteIndex >= _directorDeleteList.length)
	{
		EditMovie_AddDirector();
		return;
	}

	SetStatusMessage(_lang_modifying_director);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Director&Operation=Delete&MovieID=" + _guid + "&DirectorID=" + _directorDeleteList[_directorDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_DeleteDirector();
		}
	});
}

function EditMovie_AddDirector()
{
	if (_directorAddIndex >= _directorAddList.length)
	{
        Movie_UploadPicture();
		return;
	}
	
	var data = "MovieID=" + _guid;
	data += "&DirectorID=" + _directorAddList[_directorAddIndex];
	
	_directorAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Director&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMovie_AddDirector();
		}
	});
}

function Movie_UploadPicture()
{
    if (!_uploadPicture)
    {
        Movie_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Movie&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Movie_UploadThumbnail();
    	}
    });
}

function Movie_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Movie&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateMovie(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMovie(action, id);}, this);
		else
			UpdateMovie(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Movie&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function AddClientUrl()
{
    var form = $("form")[0];

	if (form.PlayerID.value == "")
	{
		Alert(_lang_select_player);
		return;
	}
	
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	SetCookie("PlayerID", form.PlayerID.value, 10*360*24*60);

	var urlCategory = form.UrlCategoryID.outerHTML.replace("name=UrlCategoryID", "");
	var extention = form.Extention.value == "" ? "" : "." + form.Extention.value;
	var player = form.PlayerID.outerHTML.replace("name=PlayerID", "");

	var names = new Array();
	var urls = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			names[names.length] = "01";
		else
			names[names.length] = form.UrlName.value;
		
		urls[urls.length] = form.UrlTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (form.To.value.match(/^\d+$/) == null || form.From.value.match(/^\d+$/) == null || form.Wildcard.value.match(/^\d+$/) == null)
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + r;
			else
				names[names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + r + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", r) + extention;
			}			
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){this.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){this.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				names[names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				names[names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					urls[urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + extention;
				else
					urls[urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + extention;	
			}			
		}
	}
	
	var table = $("#UrlTable tbody")[0];
	for (var i = 0; i < names.length; i++)
	{
		var row = table.insertRow(-1);
		var cell = null;
		
		cell = row.insertCell(-1);
		cell.innerHTML = urlCategory;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + names[i] + "' size='15' maxlength='50' class='Text " + _lang + "Font'" + (typeof(SetupIme) == "function" ? " onkeydown='OnEdit()' onkeypress='OnEdit()'" : "") + "/>";
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='text' value='" + urls[i] + "' size='30' maxlength='255' class='Text CHSFont' />";
		
		cell = row.insertCell(-1);
		cell.innerHTML = player;
		
		cell = row.insertCell(-1);
		cell.innerHTML = "<input type='button' value='" + _lang_delete + "' onclick='DeleteClientUrl(this)' />";
	}
}

function DeleteClientUrl(input)
{
	var table = $("#UrlTable")[0];
	table.deleteRow(input.parentNode.parentNode.rowIndex);
}

function Type_OnChange()
{
    var form = this.form;
	if (this.value == "")
	{
		$("#Batch").hide();
	}
	else
	{
		if (this.value == "0")
		{
			form.From.maxLength = 3;
			form.From.value = "1";
			form.To.maxLength = 3;
			form.To.value = "2";
	
			$("#WildcardSpan").show();
		}
		else if (form.Type.value == "1")
		{
			form.From.maxLength = 1;
			form.From.value = "A";
			form.To.maxLength = 1;
			form.To.value = "B";
	
			$("#WildcardSpan").hide();
		}

		$("#Batch").show();
	}
}
//End : 电影管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地址管理
function PrepareUrl()
{
    var form = $("form")[0];

	if (form.PlayerID.value == "")
	{
		Alert(_lang_select_player);
		return;
	}
	
	SetCookie("UrlName", form.UrlName.value, 10*360*24*60);
	SetCookie("Extention", form.Extention.value, 10*360*24*60);
	SetCookie("PlayerID", form.PlayerID.value, 10*360*24*60);
	
	_playerID = form.PlayerID.value;
	_categoryID = form.CategoryID.value;
	_extention = form.Extention.value == "" ? "" : "." + form.Extention.value;
	_counter = 0;
	
	_names = new Array();
	_urls = new Array();
	_downloads = new Array();
	if (form.Type.value == "")
	{
		if (form.UrlName.value == "")
			_names[_names.length] = "01";
		else
			_names[_names.length] = form.UrlName.value;
		
		_urls[_urls.length] = form.UrlTemplate.value;
		_downloads[_downloads.length] = form.DownloadTemplate.value;
	}
	else if (form.Type.value == "0")
	{
		if (!form.To.value.match(/^\d+$/) || !form.From.value.match(/^\d+$/) || !form.Wildcard.value.match(/^\d+$/))
		{
			Alert(_lang_must_be_number);
			return;
		}
	
		var from, to, wildcard;
		if(parseInt(form.From.value) <= parseInt(form.To.value))
		{
			from = parseInt(form.From.value);
			to = parseInt(form.To.value);
		}
		else
		{
			from = parseInt(form.To.value);
			to = parseInt(form.From.value);
		}
			
		var wildcard = parseInt(form.Wildcard.value);	
		for (var i = from; i <= to; i++)
		{
			var r = "";
			var count = Math.max(wildcard, (i + "").length) - (i + "").length;
			for (var j = 0; j < count; j++)
				r += "0";
			r += i;

			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + r;
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", r);
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + r + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", r) + _extention;
			}
			
			if (form.DownloadTemplate.value == "")
			{
				_downloads[_downloads.length] = "";
			}
			else
			{
				if (form.DownloadTemplate.value.indexOf("(*)") == -1)
					_downloads[_downloads.length] = form.DownloadTemplate.value + r + _extention;
				else
					_downloads[_downloads.length] = form.DownloadTemplate.value.replace("(*)", r) + _extention;
			}
		}
	}
	else if (form.Type.value == "1")
	{
		if (!(form.From.value >= "a" && form.From.value <= "z") && !(form.From.value >= "A" && form.From.value <= "Z"))
		{
		    Alert(_lang_from_a_to_z, function(){form.From.select();}, this);
			return;
		}
		
		if (!(form.To.value >= "a" && form.To.value <= "z") && !(form.To.value >= "A" && form.To.value <= "Z"))
		{
		    Alert(_lang_to_a_to_z, function(){form.To.select();}, this);
			return;
		}
		
		var from, to;
		if(form.From.value <= form.To.value)
		{
			from = form.From.value.charCodeAt(0);
			to = form.To.value.charCodeAt(0);
		}
		else
		{
			from = form.To.value.charCodeAt(0);
			to = form.From.value.charCodeAt(0);
		}
		
		for (var i = from; i <= to; i++)
		{
			if (form.UrlName.value.indexOf("(*)") == -1)
				_names[_names.length] = form.UrlName.value + String.fromCharCode(i);
			else
				_names[_names.length] = form.UrlName.value.replace("(*)", String.fromCharCode(i));
			
			if (form.UrlTemplate.value == "")
			{
				_urls[_urls.length] = "";
			}
			else
			{
				if (form.UrlTemplate.value.indexOf("(*)") == -1)
					_urls[_urls.length] = form.UrlTemplate.value + String.fromCharCode(i) + _extention;
				else
					_urls[_urls.length] = form.UrlTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
			
			if (form.DownloadTemplate.value == "")
			{
				_downloads[_downloads.length] = "";
			}
			else
			{
				if (form.DownloadTemplate.value.indexOf("(*)") == -1)
					_downloads[_downloads.length] = form.DownloadTemplate.value + String.fromCharCode(i) + _extention;
				else
					_downloads[_downloads.length] = form.DownloadTemplate.value.replace("(*)", String.fromCharCode(i)) + _extention;	
			}
		}
	}
}

function AddUrl()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

    if (_counter >= _names.length)
    {
    	$(":submit")[0].disabled = false;
	    Search();
        return;
    }
    
	var data = "MovieID=" + _movieID;
	data += "&CategoryID=" + _categoryID;
	data += "&Name=" + encodeURIComponent(_names[_counter]);
	data += "&Url=" + encodeURIComponent(_urls[_counter]);
	data += "&Download=" + encodeURIComponent(_downloads[_counter]);
	data += "&PlayerID=" + _playerID;
	
	_counter++;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Url&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AddUrl();
		}
	});
}

function ModifyUrl(form, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);
	data += "&URL=" + encodeURIComponent(form.URL.value);
	data += "&PlayerID=" + form.PlayerID.value;

	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Url&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
	
	return false;
}

function DeleteUrl(id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Movie.Url&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();
		}
	});
}
//End : 地址管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物管理
function AddPerson()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
	
	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddPerson_GetInnerID();
		}
	});
	
	return false;	
}

function AddPerson_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddPerson_SetPageID();
		}
	});
}

function AddPerson_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddPerson_AddTag();
		}
	});
}

function AddPerson_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPerson_AddTag();
		}
	});
}

function EditPerson()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	var data = "IsChecked=false&Name=" + encodeURIComponent(this.Name.value);
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});

	return false;
}

function EditPerson_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditPerson_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Delete&PersonID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});
}

function EditPerson_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_AddTag();
		}
	});
}

function Person_UploadPicture()
{
    if (!_uploadPicture)
    {
        Person_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Object=Person&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Person_UploadThumbnail();
    	}
    });
}

function Person_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Person&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdatePerson(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePerson(action, id);}, this);
		else
			UpdatePerson(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Person&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 人物管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "movie_add")
	{
	    var form = $("form")[0];
	    form.UrlName.value = GetCookie("UrlName");
	    form.Extention.value = GetCookie("Extention");
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
	    CheckAndSelect(form.PlayerID, GetCookie("PlayerID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddMovie);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#ActorSelect").click(function(){ShowSelectDialog("Actor")});
		$("#DirectorSelect").click(function(){ShowSelectDialog("Director")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("[name=UrlName],[name=Extention],[name=UrlTemplate]").keydown(function(e){if (e.keyCode == 13){AddClientUrl();e.preventDefault();}});
		$("#AddUrl").click(AddClientUrl);
		$("[name=Type]").change(Type_OnChange);
	}
	else if (_page == "movie_edit")
	{
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _actors.length; i++)
        {
	        SelectPerson(_actors[i], true, "Actor");
        }
        
        for (var i = 0; i < _directors.length; i++)
        {
	        SelectPerson(_directors[i], true, "Director");
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditMovie);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#ActorSelect").click(function(){ShowSelectDialog("Actor")});
		$("#DirectorSelect").click(function(){ShowSelectDialog("Director")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "movie_list")
	{
		MakeButton();
		
		if (arguments.length == 0)
		    return;
    	
	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory,#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "movie_url_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyUrl(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUrl(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

	    $("[name=UrlName]").val(GetCookie("UrlName"));
	    $("[name=Extention]").val(GetCookie("Extention"));
    	CheckAndSelect($("[name=PlayerID]")[0], GetCookie("PlayerID"));

		$("form").eq(0).submit(function(){PrepareUrl();AddUrl();return false;});
		$("[name=CategoryID]").change(Search);
		$("[name=Type]").change(Type_OnChange);
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
            if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;
		
		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "person_add")
	{
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddPerson);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "person_edit")
	{
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true)
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditPerson);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
	}
	else if (_page == "person_list")
	{
		MakeButton();
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "person_select")
	{
		$("#List :checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked, _type);
			else
				window.opener.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked, _type);
		});
		
		if (arguments.length == 0)
		    return;
		
		$("#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
}
Init(true);