﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "PositionName")
			condition.Append(and + Alias.Income.PositionName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Advertiser")
			condition.Append(and + Alias.Income.Advertiser + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "AdTitle")
			condition.Append(and + Alias.Income.AdTitle + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string FormatDate(object date)
{
	if (Convert.IsDBNull(date))
		return String.Empty;
	else
		return Convert.ToDateTime(date).ToString("yyyy-MM-dd");
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>广告位</th>
			<th>广告</th>
			<th>广告主</th>
			<th>开始日期</th>
			<th>结束日期</th>
			<th>结算日期</th>
			<th>点击数</th>
			<th>类型</th>
			<th>金额</th>
			<th>结算</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Income" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
			<ilghar:Record>
				<tr id="<%=InnerID%>">
					<td><%=PositionName%></td>
					<td><%=AdTitle%></td>
					<td><%=Advertiser%></td>
					<td><%=FormatDate(StartTime)%></td>
					<td><%=FormatDate(EndTime)%></td>
					<td><%=FormatDate(Time)%></td>
					<td><%=HitCount%></td>
					<td><%=Type%></td>
					<td><%=Amount%></td>
					<td><a href="">删除</a></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
