﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>类别列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否显示
	string isDisplay = Request.QueryString["IsDisplay"];
	if (isDisplay == null)
		condition.Append(Alias.ArticleCategory.IsDisplay + "=true");
	else if (isDisplay != String.Empty)
		condition.Append(Alias.ArticleCategory.IsDisplay + "=" + isDisplay);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.ArticleCategory.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.ArticleCategory.IsHeld + "=" + isHeld);
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.ArticleCategory.Sort + " ASC";
			break;
		case "2":
			sort = Alias.ArticleCategory.Recommend + " DESC";
			break;
		case "3":
			sort = Alias.ArticleCategory.Recommend + " ASC";
			break;
		case "4":
			sort = Alias.ArticleCategory.Hold + " DESC";
			break;
		case "5":
			sort = Alias.ArticleCategory.Hold + " ASC";
			break;
		default:
			sort = Alias.ArticleCategory.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "article_category_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_name_empty = "名称不能空！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_display = "显示";
var _lang_undisplay = "取消显示";
var _lang_recommend = "推荐";
var _lang_unrecommend = "取消推荐";
var _lang_hold = "置顶";
var _lang_unhold = "取消置顶";
var _lang_selection_empty = "没有选择任何对象！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">类别列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">类别列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx?Lang=<%=ContentLang%>">添加类别</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsDisplay">
			<option value="">是否显示</option>
			<option value="false">未显示</option>
			<option value="true" selected="selected">已显示</option>
		</select>
		<select id="IsRecommended">
			<option value="">是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<select id="IsHeld">
			<option value="">是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
		<select id="Sort">
			<option value="1" selected="selected">手动排序</option>
			<option value="2">推荐↓</option>
			<option value="3">推荐↑</option>
			<option value="4">置顶↓</option>
			<option value="5">置顶↑</option>
		</select>
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="TreeTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th width="40">移动</th>
					<th>名称及层次</th>
					<th width="40">修改</th>
					<th width="80">浏览文章</th>
					<th width="80">添加子类别</th>
					<th width="40">编辑</th>
					<th width="40">删除</th>
				</tr>
			</thead>
			<tbody>
                <ilghar:Tree Object="ArticleCategory" Condition="Condition()" Sort="Sort()" Validate="True">
                    <ilghar:Control>
                        <ilghar:Space><span style="margin-left:20px"></span></ilghar:Space>
                        <ilghar:Line><img src="<%=ImagePath%>tree/line.gif" /></ilghar:Line>
                        <ilghar:TopOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/top_open.gif" class="ShowHide" /></ilghar:TopOpen>
                        <ilghar:Top><img src="<%=ImagePath%>tree/top.gif" /></ilghar:Top>
                        <ilghar:MiddleOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/middle_open.gif" class="ShowHide" /></ilghar:MiddleOpen>
                        <ilghar:Middle><img src="<%=ImagePath%>tree/middle.gif" /></ilghar:Middle>
                        <ilghar:BottomOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/bottom_open.gif" class="ShowHide" /></ilghar:BottomOpen>
                        <ilghar:Bottom><img src="<%=ImagePath%>tree/bottom.gif" /></ilghar:Bottom>
                    </ilghar:Control>
                    <ilghar:Record>
                        <tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="<%=ParentInnerID%>">
                            <form>
                                <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
                                <td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
                                <th><span id="Control<%=InnerID%>"><%=Control%></span><input type="text" name="Name" value="<%=Name%>" class="<%=ContentLang%>Font"></th>
                                <td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
                                <td><a href="../article/list.aspx?Lang=<%=ContentLang%>&amp;CategoryID=<%=ID%>">浏览文章</a></td>
                                <td><a href="../article_category/add.aspx?Lang=<%=ContentLang%>&amp;ParentID=<%=ID%>">添加子类别</a></td>
                                <td><a href="../article_category/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
                                <td><a href="">删除</a></td>
                            </form>
                        </tr>
                        <%=ChildRecords%>
                    </ilghar:Record>
                </ilghar:Tree>
			</tbody>
		</table>
	</div>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>move.js"></script>
<script type="text/javascript" src="<%=JsPath%>tree_handler.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>article.js"></script>
</body>
</html>