﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetHostServerSettings()" Validate="True" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>服务端设置</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<style type="text/css">
TH{width:220px}
.Task{list-style:decimal}
.Task LI{margin:3px 0}
</style>
<script type="text/javascript">
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
		alert("保存成功！");
	else
		alert("保存失败！请查看日志！");

	document.getElementById("Submit").disabled = false;
	window.status = "";
}

function OnSubmit(form)
{
	if (!form.Port.value.match(/^\d*$/))
	{
		alert("端口必须是数字！");
		form.Port.select();
		return false;
	}	
	
	if (form.ServiceUrl.value.indexOf("http://") != 0)
	{
		alert("服务地址必须以http://开头！");
		form.ServiceUrl.select();
		return false;
	}
		
	if (!form.DurationToCheckAppPool.value.match(/^\d*$/))
	{
		alert("应用程序池监测间隔格式不正确！");
		form.DurationToCheckAppPool.select();
		return false;
	}
		
	if (form.PeriodToCheckExpiration.value == "Month" && (parseInt(form.DayOfMonth.value) < 1 || parseInt(form.DayOfMonth.value) > 31))
	{
		alert("过期监测天数格式不正确！");
		form.DayOfMonth.select();
		return false;
	}
		
	if (parseInt(form.HourToCheckExpiration.value) < 0 || parseInt(form.HourToCheckExpiration.value) > 23)
	{
		alert("过期监测小时数格式不正确！");
		form.DayOfMonth.select();
		return false;
	}
		
	if (parseInt(form.MinuteToCheckExpiration.value) < 0 || parseInt(form.MinuteToCheckExpiration.value) > 59)
	{
		alert("过期监测分钟数格式不正确！");
		form.DayOfMonth.select();
		return false;
	}
		
	if (form.ActionToDoAfterHostExpired.value == "Redirect" && form.RedirectUrl.value == "")
	{
		alert("请输入重定向地址！");
		form.RedirectUrl.select();
		return false;
	}
	
	if (!form.DurationToDeleteFromIISAfterHostExpired.value.match(/^\d*$/))
	{
		alert("从IIS中移除之前的天数格式不正确！");
		form.DurationToDeleteFromIISAfterHostExpired.select();
		return false;
	}
	
	if (!form.DurationToDeleteFolderAfterHostDelete.value.match(/^\d*$/))
	{
		alert("删除网站目录之前的天数格式不正确！");
		form.DurationToDeleteFolderAfterHostDelete.select();
		return false;
	}
	
	if (!form.DurationToCheckDeleteFromIISList.value.match(/^\d*$/))
	{
		alert("监测从IIS中移除列表的间隔格式不正确！");
		form.DurationToCheckDeleteFromIISList.select();
		return false;
	}
	
	if (!form.DurationToCheckDeleteFolderList.value.match(/^\d*$/))
	{
		alert("监测删除网站目录列表的间隔格式不正确！");
		form.DurationToCheckDeleteFolderList.select();
		return false;
	}
	
	var data = "Port=" + form.Port.value;
	if (form.Password.value != "")
		data += "&Password=" + encodeURIComponent(form.Password.value);
	data += "&ServiceUrl=" + encodeURIComponent(form.ServiceUrl.value);
	if (form.AnonymousUserPassword.value != "")
		data += "&Password=" + encodeURIComponent(form.AnonymousUserPassword.value);
	data += "&DurationToCheckAppPool=" + encodeURIComponent(form.DurationToCheckAppPool.value);
	data += "&PeriodToCheckExpiration=" + encodeURIComponent(form.PeriodToCheckExpiration.value);
	if (form.PeriodToCheckExpiration.value == "Week")
		data += "&DayToCheckExpiration=" + encodeURIComponent(form.DayOfWeek.value);
	else if (form.PeriodToCheckExpiration.value == "Month")
		data += "&DayToCheckExpiration=" + encodeURIComponent(form.DayOfMonth.value);
	data += "&HourToCheckExpiration=" + encodeURIComponent(form.HourToCheckExpiration.value);
	data += "&MinuteToCheckExpiration=" + encodeURIComponent(form.MinuteToCheckExpiration.value);
	data += "&ActionToDoAfterHostExpired=" + encodeURIComponent(form.ActionToDoAfterHostExpired.value);
	if (form.ActionToDoAfterHostExpired.value == "Stop")
		data += "&RedirectUrl=";
	else
		data += "&RedirectUrl=" + encodeURIComponent(form.RedirectUrl.value);
	data += "&DurationToDeleteFromIISAfterHostExpired=" + encodeURIComponent(form.DurationToDeleteFromIISAfterHostExpired.value);
	data += "&DurationToDeleteFolderAfterHostDelete=" + encodeURIComponent(form.DurationToDeleteFolderAfterHostDelete.value);
	data += "&DurationToCheckDeleteFromIISList=" + encodeURIComponent(form.DurationToCheckDeleteFromIISList.value);
	data += "&DurationToCheckDeleteFolderList=" + encodeURIComponent(form.DurationToCheckDeleteFolderList.value);

	document.getElementById("Submit").disabled = true;
	window.status = "正在操作...";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=InstanceConfig&Operation=SetHostServerSettings", data, XmlHttpCallBack);
	return false;
}

function PeriodToCheckExpiration_OnChange()
{
	var form = document.forms[0];
	if (form.PeriodToCheckExpiration.value == "Week")
	{
		document.getElementById("DayOfMonthSpan").style.display = "none";
		document.getElementById("DayOfWeekSpan").style.display = "";
	}
	else if (form.PeriodToCheckExpiration.value == "Month")
	{
		document.getElementById("DayOfMonthSpan").style.display = "";
		document.getElementById("DayOfWeekSpan").style.display = "none";
	}
	else
	{
		document.getElementById("DayOfMonthSpan").style.display = "none";
		document.getElementById("DayOfWeekSpan").style.display = "none";
	}
}

function ActionToDoAfterHostExpired_OnChange()
{
	var form = document.forms[0];
	if (form.ActionToDoAfterHostExpired.value == "Redirect")
		document.getElementById("RedirectUrlSpan").style.display = "";
	else
		document.getElementById("RedirectUrlSpan").style.display = "none";
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title">服务端设置</div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="basic.aspx?Lang=<%=ContentLang%>">基本设置</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="discount.aspx?Lang=<%=ContentLang%>">会员折扣</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="percentage.aspx?Lang=<%=ContentLang%>">会员提成</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">服务端设置</li>
		<li class="Right Selected"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnSubmit(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th width="120">端口</th>
					<td><input type="text" name="Port" value="<%=Config[HSPort]%>" maxlength="100" class="Text" /></td>
				</tr>
				<tr>
					<th>密码：</th>
					<td><input type="password" name="Password" maxlength="100" class="Text" />不修改，则留空</td>
				</tr>
				<tr>
					<th>服务地址：</th>
					<td><input type="text" name="ServiceUrl" value="<%=Config[HSServiceUrl]%>" size="60" maxlength="100" class="Text" /></td>
				</tr>
				<tr>
					<th>匿名用户密码：</th>
					<td><input type="password" name="AnonymousUserPassword" maxlength="100" class="Text" />不修改，则留空</td>
				</tr>
				<tr>
					<th>自动任务：</th>
					<td>
						<ul class="Task">
							<li>每隔<input type="text" name="DurationToCheckAppPool" value="<%=Config[HSDurationToCheckAppPool]%>" size="2" />分钟监测应用程序池</li>
							<li>
								每<select name="PeriodToCheckExpiration" onchange="PeriodToCheckExpiration_OnChange()"><option value="Day">天</option><option value="Week">周</option><option value="Month">月</option></select>
								<span id="DayOfWeekSpan" style="display:none">
									<select name="DayOfWeek">
										<option value="1">星期一</option>
										<option value="2">星期二</option>
										<option value="3">星期三</option>
										<option value="4">星期四</option>
										<option value="5">星期五</option>
										<option value="6">星期六</option>
										<option value="0">星期天</option>
									</select>
								</span>
								<span id="DayOfMonthSpan" style="display:none">
									<input type="text" name="DayOfMonth" value="<%=Config[HSDayToCheckExpiration]%>" size="2" />日
								</span>
								<input type="text" name="HourToCheckExpiration" value="<%=Config[HSHourToCheckExpiration]%>" size="2" />点
								<input type="text" name="MinuteToCheckExpiration" value="<%=Config[HSMinuteToCheckExpiration]%>" size="2" />分
								监测过期产品
							</li>
							<li>
								虚拟主机过期时，<select name="ActionToDoAfterHostExpired" onchange="ActionToDoAfterHostExpired_OnChange()"><option value="Stop">停止网站</option><option value="Redirect">重定向到</option></select>
								<span id="RedirectUrlSpan" style="display:none"><input name="RedirectUrl" value="<%=Config[HSRedirectUrl]%>" size="50" /></span><br />
							</li>
							<li>虚拟主机过期后，<input type="text" name="DurationToDeleteFromIISAfterHostExpired" value="<%=Config[HSDurationToDeleteFromIISAfterHostExpired]%>" size="2" />天后从IIS中移除</li>
							<li>虚拟主机从IIS中移除后，<input type="text" name="DurationToDeleteFolderAfterHostDelete" value="<%=Config[HSDurationToDeleteFolderAfterHostDelete]%>" size="2" />天后删除网站目录</li>
							<li>每隔<input type="text" name="DurationToCheckDeleteFromIISList" value="<%=Config[HSDurationToCheckDeleteFromIISList]%>" size="2" />分钟监测需要从IIS中移除的虚拟主机</li>
							<li>每隔<input type="text" name="DurationToCheckDeleteFolderList" value="<%=Config[HSDurationToCheckDeleteFolderList]%>" size="2" />分钟监测需要删除的网站目录</li>
						</ul>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2"><input type="submit" id="Submit" class="Button" value="保存" /></td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript">
CheckAndSelect("<%=Config[HSPeriodToCheckExpiration]%>", document.forms[0].PeriodToCheckExpiration);
CheckAndSelect("<%=Config[HSDayToCheckExpiration]%>", document.forms[0].DayOfWeek);
PeriodToCheckExpiration_OnChange();

CheckAndSelect("<%=Config[HSActionToDoAfterHostExpired]%>", document.forms[0].ActionToDoAfterHostExpired);
ActionToDoAfterHostExpired_OnChange();

HandleFake404();
</script>
</body>
</html>