﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>发票列表</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 状态
	string status = Request.QueryString["Status"];
	if (!String.IsNullOrEmpty(status))
		condition.Append(and + Alias.Invoice.Status + "=" + status);
	else
		condition.Append(and + Alias.Invoice.Status + "=1");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Invoice.Number + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Member")
			condition.Append(and + Alias.Invoice.Member + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}
</script>
<script type="text/javascript">
var _page = 1;
var _action = null;
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		var list = document.getElementById("List");
		list.innerHTML = HandleFake404(xmlHttp);

		if (_action == "Delete")		
			alert("删除成功！");
	}
	else
	{
		if (_action == "Delete")
			alert("删除失败！请查看日志！");
	}
}

function BuildHeader()
{
	return BuildAjaxPath(true) + "?Lang=<%=ContentLang%>&Status=" + document.getElementById("Status").value + "&Keyword=" + encodeURIComponent(document.getElementById("Keyword").value) + "&KeywordType=" + document.getElementById("KeywordType").value + "&Page=" + _page;
}

function OnSearch()
{
	if (arguments.length > 0)
		_page = arguments[0];
		
	_action = "Search";
	_ajax.Post(BuildHeader(), null, XmlHttpCallBack);
	return false;
}

function OnDelete(id)
{
	if (!confirm("要删除此项吗？"))
		return;
	
	_objectID = id;
	_action = "Delete";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Invoice&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()), null, XmlHttpCallBack);
}

function OnConfirm(id)
{
	_action = "Confirm";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Invoice&Operation=Confirm&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()), null, XmlHttpCallBack);
}

function OnCancel(id)
{
	if (!confirm("要取消此项吗？"))
		return;
	
	_action = "Cancel";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Invoice&Operation=Cancel&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()), null, XmlHttpCallBack);
}

function OnPost(id)
{
	window.location.href = HandleFake404("post.aspx?Lang=<%=ContentLang%>&ID=" + id);
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title">发票列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" onmouseover="this.src='<%=ImagePath%>dropdown_over.gif';ShowLanguageMenu(this);" onmouseout="this.src='<%=ImagePath%>dropdown.gif'" />
		语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">发票列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx?Lang=<%=ContentLang%>">代申请发票</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Status" onchange="OnSearch()">
			<option value="">-- 发票状态 --</option>
			<option value="1" selected="selected">未受理</option>
			<option value="2">已受理</option>
			<option value="3">已取消</option>
			<option value="4">已发送</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" onkeydown="if(event.keyCode == 13) OnSearch(1);" />
		<select id="KeywordType">
			<option value="Number">发票号</option>
			<option value="Member">会员名</option>
		</select>
		<input type="button" value="搜索" class="Button" onclick="OnSearch(1)" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>发票号</th>
					<th>金额</th>
					<th>会员名</th>
					<th>电话</th>
					<th>申请时间</th>
					<th>更新时间</th>
					<th>状态</th>
					<th width="120">操作</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Invoice" Page="PageNumber" PageSize="20" Condition="Condition()" Validate="True">
					<ilghar:Record>
						<tr id="Row<%=InnerID%>">
							<td><%=Number%></td>
							<td><%=Amount%></td>
							<td><%=Member%></td>
							<td><%=Phone%></td>
							<td><%=CreateTime%></td>
							<td><%=UpdateTime%></td>
							<td>
								<%If Int32.Equals(Status, 1)%>
									未受理
								<%ElseIf Int32.Equals(Status, 2)%>
									已受理
								<%ElseIf Int32.Equals(Status, 3)%>
									已取消
								<%ElseIf Int32.Equals(Status, 4)%>
									已发送
								<%EndIf%>
							</td>
							<td>
								<%If Int32.Equals(Status, 1)%>
									<input type="button" value="受理" onclick="OnConfirm('<%=InnerID%>')" />
								<%ElseIf Int32.Equals(Status, 2)%>
									<input type="button" value="发送" onclick="OnPost('<%=InnerID%>')" />
									<input type="button" value="取消" onclick="OnCancel('<%=InnerID%>')" />
								<%EndIf%>
								<input type="button" value="删除" onclick="OnDelete('<%=InnerID%>')" />
							</td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>