﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Order.Detail.IsCanceled + "=false");
	string and = " AND ";

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind != null && kind != "*")
		condition.Append(and + Alias.Order.Detail.Kind + "='" + kind + "'");
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Order.Detail.OrderNumber + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Member")
			condition.Append(and + Alias.Order.Detail.Member + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Order.Detail.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Order.Detail.InnerID + " ASC";
			break;
		case "3":
			sort = Alias.Order.Detail.ExpiredTime + " DESC";
			break;
		case "4":
			sort = Alias.Order.Detail.ExpiredTime + " ASC";
			break;
		default:
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr>
			<th>名称</th>
			<th>订单号</th>
			<th>会员</th>
			<th>创建时间</th>
			<th>状态</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Order.Detail" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr>
					<td class="<%=ContentLang%>Font">
						<a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a>
					</td>
					<td><a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=OrderInnerID%>"><%=OrderNumber%></a></td>
					<td class="<%=ContentLang%>Font"><%=Member%></td>
					<td><%=CreateTime%></td>
					<td>
						<%If Int32.Equals(DeliveredAmount, Amount)%>
							已发货
						<%ElseIf Convert.ToInt32(DeliveredAmount) > 0%>
							部分发货
						<%Else%>
							未发货
						<%EndIf%>
						<%If Convert.ToBoolean(OnTrial)%>
							，试用中
						<%EndIf%>
						<%If !Convert.IsDBNull(ExpiredTime)%>
							<%If DateTime.Now > Convert.ToDateTime(ExpiredTime)%>
								，已过期
								<%If String.Equals(Kind, "Host") && Guid.Equals(ServerID, Guid.Empty)%>
								，已删除
								<%EndIf%>
							<%Else%>
								，<%=Convert.ToDateTime(ExpiredTime).Subtract(DateTime.Now).Days + 1%>天后过期
							<%EndIf%>
						<%EndIf%>
					</td>
					<td>
						【<a href="feedback.aspx?ID=<%=InnerID%>">反馈</a>】

						<%If !Convert.IsDBNull(ExpiredTime) && Int32.Equals(DeliveredAmount, Amount) && (!String.Equals(Kind, "Host") || !Guid.Equals(ServerID, Guid.Empty))%>
							【<a href="javascript:ShowActionDialog(<%=InnerID%>, 'Update')">续费</a>】
						<%EndIf%>
						
						<%If String.Equals(Kind, "Host") && !Guid.Equals(ServerID, Guid.Empty)%>
							【<a href="host.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">管理</a>】
							<ilghar:List Source="Manager.SplitToTable(ServerBindings)">
								<ilghar:Record>
									<a href="http://<%=[0]%>" target="_blank" style="display:block">http://<%=[0]%></a>
								</ilghar:Record>
							</ilghar:List>
						<%EndIf%>

						<%If String.Equals(Kind, "WebSite")%>
							<input type="checkbox" id="Auto<%=InnerID%>" onclick="Auto_OnClick(this, <%=InnerID%>)" /><label for="Auto<%=InnerID%>">自动</label>
							<span id="FileSpan<%=InnerID%>"><input type="text" id="File<%=InnerID%>" value="<%=File%>" size="10" /><input type="button" value="..." size="3" onclick="ShowSelectFileDialog(<%=InnerID%>)" /></span>
							<input type="button" value="设置" onclick="OnSet(<%=InnerID%>)" />
						<%EndIf%>
					</td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>