﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Order" Object="Order" InnerID="Request.QueryString['ID']" />
<ilghar:List ID="Unit" Object="Unit" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>编辑订单</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=Manager.GetModulePath(null)%><%=Instance[IlgharCMS.SystemModule.Alias.Module.Namespace]%>/alias.js"></script>
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=CommonPath%>xmldom.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
TD TABLE{background:#FFF}
TD TABLE TH{width:100px}
#DetailTable THEAD TH,#DetailTable TBODY TD{width:auto;text-align:center}
</style>
<script language="c#" runat="server">
protected string GetUnitName(object unitID)
{
	if (Guid.Equals(unitID, Guid.Empty))
		return String.Empty;

	DataRow[] rows = Unit.Select(Alias.Unit.ID + "='" + unitID + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Unit.Name].ToString();
}
</script>
<script type="text/javascript">
var _action = null;
var _xmlDoc = CreateXmlDom();
var _childIndex = 0;
var _children = new Array();
var _parentID;
var _product;
var _price = <%=Order[Price]%>;

var _discount = new Array();
<ilghar:List Object="Discount">
	<ilghar:Record>
		_discount[_discount.length] = new Object();
		_discount[_discount.length - 1].RoleInnerID = "<%=RoleInnerID%>";
		_discount[_discount.length - 1].Amount = "<%=Amount%>";
	</ilghar:Record>
</ilghar:List>

function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		if (_action == "Edit")
		{
			if (_product == null)
			{
				alert("编辑成功！");
				document.getElementById("Submit").disabled = false;
				window.status = "";
			}
			else if (typeof(_product) == "object")
			{
				_action = "AddProduct";
				window.status = "正在添加产品...";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Add", "OrderID=<%=Order[ID]%>&ProductID=" + _product.ProductID + "&ProductNumber=" + _product.ProductNumber + "&Name=" + _product.Name + "&Kind=" + _product.Kind + "&Amount=" + _product.Amount + "&UnitID=" + _product.UnitID + "&Price=" + _product.Price, XmlHttpCallBack);
			}
			else
			{
				_action = "DeleteProduct";
				window.status = "正在删除产品...";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Delete&ID=" + _product, null, XmlHttpCallBack);
			}
		}
		else if (_action == "AddProduct" || _action == "AddChild")
		{
			if (_childIndex < _product.Children.length)
			{
				if (_action == "AddProduct")
				{
					_childIndex = 0;
					_parentID = xmlHttp.responseText;
				}

				var child = _children[_childIndex];
				_action = "AddChild";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Add", "OrderID=<%=Order[ID]%>&ParentID=" + _parentID + "&ProductID=" + child.ProductID + "&ProductNumber=" + child.ProductNumber + "&Name=" + child.Name + "&Kind=" + child.Kind + "&UnitAmount=" + child.UnitAmount + "&Amount=" + child.Amount + "&UnitID=" + child.UnitID + "&Price=" + child.Price + "&IsBinding=" + child.IsBinding + "&IsPresent=" + child.IsPresent, XmlHttpCallBack);
				_childIndex++;
			}
			else
			{
				alert("添加成功！");
				document.getElementById("Submit").disabled = false;
				window.status = "";
			}
		}
		else if (_action == "DeleteProduct")
		{
			alert("删除成功！");
			document.getElementById("Submit").disabled = false;
			window.status = "";
		}
		else if (_action == "BindingList")
		{
			var html = "";
			_xmlDoc.loadXML(xmlHttp.responseText);
			var items = _xmlDoc.documentElement.childNodes;
			for (var i = 0; i < items.length; i++)
			{
				if (typeof (items[i].selectSingleNode) == "undefined")
					continue;
				
				var id = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingID).text;
				var number = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingNumber).text;
				var name = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingName).text;
				var kind = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingKind).text;
				var price = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingPrice).text;
				var unitID = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingUnitID).text;
				var unitName = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.BindingUnitName).text;
				var amount = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.Amount).text;
				var isPresent = items[i].selectSingleNode(IlgharCMS.HostModule.Product_Binding.IsPresent).text;
				html += "<blockquote productID='" + id + "' productNumber='" + number + "' name='" + name + "' kind='" + kind + "' price='" + price + "' unitID='" + unitID + "' unitAmount='" + amount + "' amount='" + amount + "' isPresent='" + isPresent + "' style='margin:0 0 0 20px'> + " + name + " - <span unitAmount='" + amount + "'>" + amount + "</span>" + unitName + "</blockquote>";
			}
			
			if (html != "")
			{
				var table = document.getElementById("DetailTable");
				table.rows[1].cells[1].innerHTML += html;
			}
		}
	}
	else
	{
		if (_action == "Edit")
			alert("编辑失败！请查看日志！");
		else if (_action == "AddProduct")
			alert("添加产品失败！请查看日志！");
		else if (_action == "AddChild")
			alert("添加子产品失败！请查看日志！");
		else
			alert("失败！请查看日志！");
		document.getElementById("Submit").disabled = false;
		window.status = "";
	}
}

function OnSubmit(form)
{
	if (form == null)
		form = document.forms[0];
	else
		_product = null;
	
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
	{
		alert("折扣或涨价不正确！");
		form.PriceAdjustment.select();
		return false;
	}
	
	if (document.getElementById("Member").memberID == "")
	{
		alert("请选择会员！");
		return false;
	}
	
	var data = "Number=" + (form.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : form.Number.value);
	data += "&Member=" + encodeURIComponent(document.getElementById("Member").member);
	data += "&MemberID=" + document.getElementById("Member").memberID;
	data += "&Discount=" + document.getElementById("Member").discount;
	data += "&NeedInvoice=" + document.getElementById("NeedInvoiceYes").checked;
	data += "&PriceAdjustment=" + form.PriceAdjustment.value;
	data += "&Memo=" + encodeURIComponent(form.Memo.value);
	data += "&Price=" + _price;
	data += "&Sum=" + document.getElementById("SumTD").innerHTML;
	
	document.getElementById("Submit").disabled = true;
	window.status = "正在操作...";
	_action = "Edit";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order&Operation=Modify&ID=<%=Request.QueryString["ID"]%>", data, XmlHttpCallBack);
	return false;
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Member")
		path = "select_member.aspx?Lang=<%=ContentLang%>";
	else if (type == "Product")
		path = "../product/select.aspx?Lang=<%=ContentLang%>&Type=" + type;
		
	path = HandleFake404(path);
	if (g_browser == "IE")
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function SelectMember(id, name, roleInnerIDs)
{
	var member = document.getElementById("Member");
	member.innerHTML = name;
	member.memberID = id;
	member.member = name;
	
	var discount = 100;
	for (var i = 0; i < _discount.length; i++)
	{
		if (roleInnerIDs.indexOf("|" + _discount[i].RoleInnerID + "|") != -1)
		{
			if (parseInt(_discount[i].Amount) < discount)
				discount = parseInt(_discount[i].Amount);
		}
	}
	member.discount = discount;
	
	Compute();
}

function SelectProduct(control)
{
	var table = document.getElementById("DetailTable");
	var row = table.rows[1];
	row.cells[0].innerHTML = control.ProductNumber;
	row.cells[1].innerHTML = control.Name;
	row.cells[2].innerHTML = control.Price;
	
	row.productID = control.ProductID;
	row.productNumber = control.ProductNumber;
	row.name = control.Name;
	row.kind = control.Kind;
	row.price = control.Price;
	row.unitID = control.UnitID;

	document.getElementById("UnitName").innerHTML = control.UnitName;
	
	_action = "BindingList";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Product.Binding&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.HostModule.Product_Binding.ProductID + "=" + control.ProductID), null, XmlHttpCallBack);	
}

function AddProduct()
{
	var table = document.getElementById("DetailTable");
	var row1 = table.rows[1];
	for (var i = 2; i < table.rows.length; i++)
	{
		if (table.rows[i].productID == row1.productID)
		{
			alert("该产品已经添加！");
			return;
		}
	}
	
	if (!document.forms[0].Amount.value.match(/^[1-9]\d*$/))
	{
		alert("数量不正确！");
		document.forms[0].Amount.select();
		return;
	}
	
	if (typeof(row1.productNumber) == "undefined")
	{
		alert("请选择产品！");
		return;
	}
	
	var row = table.insertRow();
	row.productID = row1.productID;
	row.productNumber = row1.productNumber;
	row.name = row1.name;
	row.kind = row1.kind;
	row.price = row1.price;
	row.unitID = row1.unitID;
	row.amount = document.forms[0].Amount.value;
	
	var cell = row.insertCell();
	cell.innerHTML = row.productNumber;
	cell = row.insertCell();
	cell.innerHTML = row1.cells[1].innerHTML;
	cell.style.textAlign = "left";
	cell = row.insertCell();
	cell.innerHTML = row.price;
	cell = row.insertCell();
	cell.innerHTML = document.forms[0].Amount.value;
	cell = row.insertCell();
	cell.innerHTML = "<input type=\"button\" value=\"删除\" onclick=\"DeleteProduct(this)\" /> ";
	
	Compute();
	
	_product = new Object();
	_product.ProductID = row.productID;
	_product.ProductNumber = row.productNumber;
	_product.Name = row.name;
	_product.Kind = row.kind;
	_product.Amount = row.amount;
	_product.UnitID = row.unitID;
	_product.Price = row.price;
	
	var bqs = row.cells[1].getElementsByTagName("BLOCKQUOTE");
	for (var j = 0; j < bqs.length; j++)
	{
		var child = new Object();
		child.ProductID = bqs[j].productID;
		child.ProductNumber = bqs[j].productNumber;
		child.Name = bqs[j].name;
		child.Kind = bqs[j].kind;
		child.UnitAmount = bqs[j].unitAmount;
		child.Amount = bqs[j].amount;
		child.UnitID = bqs[j].unitID;
		child.Price = bqs[j].price;
		child.IsBinding = true;
		child.IsPresent = bqs[j].isPresent;
		_children[_children.length] = child;
	}
	_product.Children = _children;
	
	OnSubmit();
}

function DeleteProduct(input)
{
	_product = input.parentNode.parentNode.id;
	document.getElementById("DetailTable").deleteRow(input.parentNode.parentNode.rowIndex);
	Compute();

	OnSubmit();
}

function Compute()
{
	var form = document.forms[0];
	var discount = parseFloat(document.getElementById("Member").discount);
	var taxRate = <%=Order[TaxRate]%>;
	var priceAdjustment = 0;
	_price = 0;
	
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d{1,3})?$/))
	{
		alert("折扣或涨价格式不正确！");
		return;
	}
	priceAdjustment = parseFloat(form.PriceAdjustment.value);
	
	var detailTable = document.getElementById("DetailTable");
	if (detailTable.rows.length == 2)
	{
		document.getElementById("SumTD").innerHTML = "0";
		return;
	}
	
	for (var i = 2; i < detailTable.rows.length; i++)
	{
		var row = detailTable.rows[i];
		
		_price += parseFloat(row.price) * parseFloat(row.amount);
	}
	
	var beforeTax = _price - _price * (100 - discount) / 100;
	var afterTax = beforeTax;
	if (document.getElementById("NeedInvoiceYes").checked)
		afterTax = beforeTax + beforeTax * taxRate / 100;
	var sum = (afterTax + priceAdjustment).toFixed(2);
		
	document.getElementById("SumTD").innerHTML = sum;
}

function Amount_OnKeyUp(amount)
{
	if (!amount.match(/^[1-9]\d*$/))
	{
		alert("数量不正确！");
		return;
	}
	
	var table = document.getElementById("DetailTable");
	var spans = table.rows[1].cells[1].getElementsByTagName("SPAN");
	for (var i = 0; i < spans.length; i++)
	{
		amount = parseInt(spans[i].unitAmount) * parseInt(amount);
		spans[i].innerHTML = amount;
		spans[i].parentNode.amount = amount;
	}
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title"><a href="list.aspx?Lang=<%=ContentLang%>">订单列表</a> → <span class="<%=ContentLang%>Font"><%=Order[Number]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">编辑</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="feedback.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">反馈</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnSubmit(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th width="120">订单号：</th>
					<td><input type="text" name="Number" value="<%=Order[Number]%>" size="30" maxlength="50" class="Text" />如果留空，则会自动生成</td>
				</tr>
				<tr>
					<th>会员：</th>
					<td><span id="Member" member="<%=Order[Member]%>" memberID="<%=Order[MemberID]%>" discount="<%=Order[Discount]%>" class="<%=ContentLang%>Font"><%=Order[Member]%></span><input type="button" value="选择" onclick="ShowSelectDialog('Member')" /></td>
				</tr>
				<tr>
					<th>发票：</th>
					<td>
						<table border="0" cellpadding="4" cellspacing="1">
							<tr>
								<th>是否需要：</th>
								<td>
									<%If Convert.ToBoolean(Order[NeedInvoice])%>
										<input type="radio" name="NeedInvoice" id="NeedInvoiceYes" checked="checked" onclick="Compute()" /><label for="NeedInvoiceYes">是</label>
										<input type="radio" name="NeedInvoice" id="NeedInvoiceNo" onclick="Compute()" /><label for="NeedInvoiceNo">否</label>
									<%Else%>
										<input type="radio" name="NeedInvoice" id="NeedInvoiceYes" onclick="Compute()" /><label for="NeedInvoiceYes">是</label>
										<input type="radio" name="NeedInvoice" id="NeedInvoiceNo" checked="checked" onclick="Compute()" /><label for="NeedInvoiceNo">否</label>
									<%EndIf%>
								</td>
							</tr>
							<tr>
								<th>税率：</th>
								<td><%=Order[TaxRate]%>%</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<th>折扣或涨价：</th>
					<td><input type="text" name="PriceAdjustment" value="<%=Order[PriceAdjustment]%>" size="10" maxlength="20" class="Text" onchange="Compute()" /></td>
				</tr>
				<tr>
					<th>备注：</th>
					<td><textarea name="Memo" cols="70" rows="6" wrap="off" class="Text <%=ContentLang%>Font"><%=Order[Memo]%></textarea></td>
				</tr>
				<tr>
					<td colspan="2">
						<table id="DetailTable" border="0" cellpadding="4" cellspacing="1">
							<thead>
								<tr>
									<th style="width:120px">货号</th>
									<th>名称</th>
									<th style="width:60px">价格</th>
									<th style="width:60px">数量</th>
									<th style="width:80px">添加/删除</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>&nbsp;</td>
									<td style="text-align:left">&nbsp;</td>
									<td>&nbsp;</td>
									<td><input type="text" name="Amount" value="1" size="5" onkeyup="Amount_OnKeyUp(this.value)" /><span id="UnitName"></span></td>
									<td>
										<input type="button" value="添加" onclick="AddProduct(this.form)" />
										<input type="button" value="选择" onclick="ShowSelectDialog('Product')" />
									</td>
								</tr>
								<ilghar:List Object="Order.Detail" Condition="OrderID=Order[ID] and ParentID IS NULL">
									<ilghar:Record>
										<tr id="<%=InnerID%>" productID="<%=ProductID%>">
											<td><%=ProductNumber%></td>
											<td class="<%=ContentLang%>Font" style="text-align:left">
												<%=Name%>
												<ilghar:List Object="Order.Detail" Condition="OrderID=Order[ID] and ParentID=ID">
													<ilghar:Record>
														<blockquote style="margin:0 0 0 20px"> + <%=Name%> - <%=Amount%> <%=GetUnitName(UnitID)%></blockquote>
													</ilghar:Record>
												</ilghar:List>
											</td>
											<td><%=Price%></td>
											<td class="<%=ContentLang%>Font"><%=Amount%> <%=GetUnitName(UnitID)%></td>
											<td><input type="button" value="删除" onclick="DeleteProduct(this)" /></td>
										</tr>
									</ilghar:Record>
								</ilghar:List>
							</tbody>
						</table>
					</td>
				</tr>
				<tr>
					<th>订单总价：</th>
					<td id="SumTD"><%=Order[Sum]%></td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" id="Submit" value="编辑" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>