﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>产品列表</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>move.js"></script>
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<style type="text/css">
.Block TBODY TD{text-align:center}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind == "")
		condition.Append(Alias.Product.Kind + " IS NULL");
	else if (kind != null && kind != "*")
		condition.Append(Alias.Product.Kind + "='" + kind + "'");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否显示
	string isDisplay = Request.QueryString["IsDisplay"];
	if (isDisplay == null)
		condition.Append(and + Alias.Product.IsDisplay + "=true");
	else if (isDisplay != String.Empty)
		condition.Append(and + Alias.Product.IsDisplay + "=" + isDisplay);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(and + Alias.Product.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(and + Alias.Product.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Product.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Product.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Product.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Product.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Product.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Product.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Product.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Product.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Product.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Product.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Product.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Product.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Product.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Product.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Product.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Product.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Product.Up + " DESC";
			break;
		case "12":
			sort = Alias.Product.Up + " ASC";
			break;
		case "13":
			sort = Alias.Product.Down + " DESC";
			break;
		case "14":
			sort = Alias.Product.Down + " ASC";
			break;
		default:
			sort = Alias.Product.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool Move
{
	get
	{
		if (Request.QueryString["Sort"] == "5" || Request.QueryString["Sort"] == "6")
			return Request.QueryString["IsRecommended"] == "true";
		else if (Request.QueryString["Sort"] == "7" || Request.QueryString["Sort"] == "8")
			return Request.QueryString["IsHeld"] == "true";
		else
			return false;
	}
}

protected bool ListByPicture
{
	get
	{
		if (Request.QueryString["ListByPicture"] != null)
			return Convert.ToBoolean(Request.QueryString["ListByPicture"]);
		else if (Request.Cookies["ListByPicture"] != null)
			return Convert.ToBoolean(Request.Cookies["ListByPicture"].Value);
		else
			return false;
	}
}
</script>
<script type="text/javascript">
var _page = 1;
var _action = null;
var _objectID = null;
function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		var list = document.getElementById("List");
		list.innerHTML = HandleFake404(xmlHttp);

		if (typeof(SetupIme) == "function")
			SetupIme();
		
		var moveAction = "";
		if (document.getElementById("IsRecommended").selectedIndex == 2 && (document.getElementById("Sort").value == "5" || document.getElementById("Sort").value == "6"))
			moveAction = "MoveRecommend";
		else if (document.getElementById("IsHeld").selectedIndex == 2 && (document.getElementById("Sort").value == "7" || document.getElementById("Sort").value == "8"))
			moveAction = "MoveHold";
		if (moveAction != "")
			g_action = moveAction;
		
		if (_action == "Recycle")
			alert("回收成功！");
		else if (_action == "Delete")
			alert("删除成功！");
		else if (_action == "Recover")
			alert("还原成功！");
		else if (_action == "Check")
			alert("审核成功！");
		else if (_action == "UnCheck")
			alert("取消审核成功！");
		else if (_action == "Recommend")
			alert("推荐成功！");
		else if (_action == "UnRecommend")
			alert("取消推荐成功！");
		else if (_action == "Hold")
			alert("置顶成功！");
		else if (_action == "UnHold")
			alert("取消置顶成功！");
		else if (_action == "Search")
			MakeButton();
	}
	else
	{
		if (_action == "Recycle")
			alert("回收失败！请查看日志！");
		else if (_action == "Delete")
			alert("删除失败！请查看日志！");
		else if (_action == "Recover")
			alert("还原失败！请查看日志！");
		else if (_action == "Check")
			alert("审核失败！请查看日志！");
		else if (_action == "UnCheck")
			alert("取消审核失败！请查看日志！");
		else if (_action == "Recommend")
			alert("推荐失败！请查看日志！");
		else if (_action == "UnRecommend")
			alert("取消推荐失败！请查看日志！");
		else if (_action == "Hold")
			alert("置顶失败！请查看日志！");
		else if (_action == "UnHold")
			alert("取消置顶失败！请查看日志！");
		else
			alert("失败！请查看日志！");
	}
	
	_action = null;
	_objectID = null;
	window.status = "";
}

function BuildHeader()
{
	var category = "";
	if (document.getElementById("CategoryID") != null)
		category = "&CategoryID=" + document.getElementById("CategoryID").value + "&IncludeSubCategory=" + document.getElementById("IncludeSubCategory").checked;

	var kind = "";
	var radios = document.getElementsByName("Kind");
	for (var i = 0; i < radios.length; i++)
	{
		if (radios[i].checked)
		{
			kind = "&Kind=" + radios[i].value;
			break;
		}
	}

	return BuildAjaxPath(true) + "?Lang=<%=ContentLang%>" + kind + "&IsDisplay=" + document.getElementById("IsDisplay").value + "&IsRecycled=" + document.getElementById("IsRecycled").value + "&IsChecked=" + document.getElementById("IsChecked").value + "&IsHeld=" + document.getElementById("IsHeld").value + "&IsRecommended=" + document.getElementById("IsRecommended").value + category + "&Sort=" + document.getElementById("Sort").value + "&Keyword=" + encodeURIComponent(document.getElementById("Keyword").value) + "&KeywordType=" + document.getElementById("KeywordType").value + "&ListByPicture=" + document.getElementById("ListByPicture").checked + "&Page=" + _page;
}

function OnSearch()
{
	if (arguments.length > 0)
		_page = arguments[0];
		
	_action = "Search";
	window.status = "正在操作...";
	_ajax.Post(BuildHeader(), null, XmlHttpCallBack);
	return false;
}

function Update(action)
{
	if (_action != null)
	{
		alert("请稍等，目前有一项正在操作！");
		return;
	}
	
	var id = GetChecked("Sel");
	if(id == "")
	{
		alert("没有选择任何对象！");
		return;
	}
	
	if(action == "Delete" && !confirm("真的要删除吗？"))
		return;
	
	_objectID = id;
	_action = action;
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Product&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()), null, XmlHttpCallBack);
}

function Move(fromID, toID, action)
{
	if (fromID == toID)
		return;

	_action = g_action;
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Product&Operation=" + g_action + "&From=" + fromID + "&To=" + toID + "&Transfer=" + encodeURIComponent(BuildHeader()), null, XmlHttpCallBack);
}

function ListByPicture_OnClick()
{
	SetCookie("ListByPicture", document.getElementById("ListByPicture").checked, 10*360*24*60);
	OnSearch();
}

function Kind_OnClick()
{
	var kind;
	var inputs = document.getElementsByTagName("INPUT");
	for (var i = 0; i < inputs.length; i++)
	{
		if (inputs[i].name == "Kind" && inputs[i].checked)
		{
			kind = inputs[i].value;
			break;
		}
	}
	window.location.href = HandleFake404("list.aspx?Kind=" + kind);
}

function MakeButton()
{
	var buttons = "";
	
	//回收
	var obj = document.getElementById("IsRecycled");
	if (obj.selectedIndex == 1)
	{
		buttons += "<button class=\"Button\" onclick=\"Update('Recycle')\" >回收</button>";
	}
	else if (obj.selectedIndex == 2)
	{
		buttons += "<button class=\"Button\" onclick=\"Update('Delete')\" >删除</button>";
		buttons += "<button class=\"Button\" onclick=\"Update('Recover')\" >还原</button>";
	}
	
	//审核
	var obj = document.getElementById("IsChecked");
	if (obj.selectedIndex == 1)
	{
		buttons += "<button class=\"Button\" onclick=\"Update('Check')\" >审核</button>";
	}
	else if (obj.selectedIndex == 2)
	{
		buttons += "<button class=\"Button\" onclick=\"Update('UnCheck')\" >取消审核</button>";
	}
	
	//置顶
	var obj = document.getElementById("IsHeld");
	if (obj.selectedIndex == 1)
		buttons += "<button class=\"Button\" onclick=\"Update('Hold')\" >置顶</button>";
	else if (obj.selectedIndex == 2)
		buttons += "<button class=\"Button\" onclick=\"Update('UnHold')\" >取消置顶</button>";
	
	//推荐
	var obj = document.getElementById("IsRecommended");
	if (obj.selectedIndex == 1)
		buttons += "<button class=\"Button\" onclick=\"Update('Recommend')\" >推荐</button>";
	else if (obj.selectedIndex == 2)
		buttons += "<button class=\"Button\" onclick=\"Update('UnRecommend')\" >取消推荐</button>";
	
	//缩略图显示
	if (GetCookie("ListByPicture").toLowerCase() == "true")
		document.getElementById("ListByPicture").checked = true;	
	else
		document.getElementById("ListByPicture").checked = false;
		
	document.getElementById("ExtraButton").innerHTML = buttons;
}
</script>
</head>
<body onload="InitMove(null,'Move',null, Move)">
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title">产品列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" onmouseover="this.src='<%=ImagePath%>dropdown_over.gif';ShowLanguageMenu(this);" onmouseout="this.src='<%=ImagePath%>dropdown.gif'" />
		语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">产品列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx?Lang=<%=ContentLang%>">添加产品</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="replace.aspx?Lang=<%=ContentLang%>">批量替换</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<%If Request.QueryString["Kind"] == "AutoSite"%>
			<input type="radio" name="Kind" id="AutoSite" value="AutoSite" checked="checked" onclick="Kind_OnClick()" /><label for="AutoSite">智能建站</label>
		<%Else%>
			<input type="radio" name="Kind" id="AutoSite" value="AutoSite" onclick="Kind_OnClick()" /><label for="AutoSite">智能建站</label>
		<%EndIf%>
		<%If Request.QueryString["Kind"] == "Host"%>
			<input type="radio" name="Kind" id="Host" value="Host" checked="checked" onclick="Kind_OnClick()" /><label for="Host">虚拟主机</label>
		<%Else%>
			<input type="radio" name="Kind" id="Host" value="Host" onclick="Kind_OnClick()" /><label for="Host">虚拟主机</label>
		<%EndIf%>
		<%If Request.QueryString["Kind"] == "WebSite"%>
			<input type="radio" name="Kind" id="WebSite" value="WebSite" checked="checked" onclick="Kind_OnClick()" /><label for="WebSite">网站</label>
		<%Else%>
			<input type="radio" name="Kind" id="WebSite" value="WebSite" onclick="Kind_OnClick()" /><label for="WebSite">网站</label>
		<%EndIf%>
		<%If Request.QueryString["Kind"] == "Set"%>
			<input type="radio" name="Kind" id="Set" value="Set" checked="checked" onclick="Kind_OnClick()" /><label for="Set">套餐</label>
		<%Else%>
			<input type="radio" name="Kind" id="Set" value="Set" onclick="Kind_OnClick()" /><label for="Set">套餐</label>
		<%EndIf%>
		<%If Request.QueryString["Kind"] == ""%>
			<input type="radio" name="Kind" id="Other" value="" checked="checked" onclick="Kind_OnClick()" /><label for="Other">其他</label>
		<%Else%>
			<input type="radio" name="Kind" id="Other" value="" onclick="Kind_OnClick()" /><label for="Other">其他</label>
		<%EndIf%>
		<%If Request.QueryString["Kind"] == null || Request.QueryString["Kind"] == "*"%>
			<input type="radio" name="Kind" id="All" value="*" checked="checked" onclick="Kind_OnClick()" /><label for="All">所有</label>
		<%Else%>
			<input type="radio" name="Kind" id="All" value="*" onclick="Kind_OnClick()" /><label for="All">所有</label>
		<%EndIf%>
	</div>
	<div class="ToolBar">
		<select id="IsDisplay" onchange="OnSearch()">
			<option>是否显示</option>
			<option value="false">隐藏</option>
			<option value="true" selected="selected">显示</option>
		</select>
		<select id="IsRecycled" onchange="OnSearch()">
			<option>是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="IsChecked" onchange="OnSearch()">
			<option>是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="IsHeld" onchange="OnSearch()">
			<option>是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
		<select id="IsRecommended" onchange="OnSearch()">
			<option>是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<%If Request.QueryString["Kind"] != null && Request.QueryString["Kind"] != "*"%>
			<select id="CategoryID" onchange="OnSearch()" class="<%=ContentLang%>Font">
				<option>所有类别</option>
				<option value="0">未指定类别</option>
				<ilghar:Tree Object="ProductCategory" Condition="Kind=Request.QueryString['Kind']">
					<ilghar:Control>
						<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
						<ilghar:Line>│</ilghar:Line>
						<ilghar:TopOpen>┌</ilghar:TopOpen>
						<ilghar:Top>┌</ilghar:Top>
						<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
						<ilghar:Middle>├</ilghar:Middle>
						<ilghar:BottomOpen>└</ilghar:BottomOpen>
						<ilghar:Bottom>└</ilghar:Bottom>
					</ilghar:Control>
					<ilghar:Record>
						<option value="<%=ID%>"><%=Control%><%=Name%></option>
						<%=ChildRecords%>
					</ilghar:Record>
				</ilghar:Tree>
			</select>
			<input type="checkbox" id="IncludeSubCategory" onClick="OnSearch()" /><label for="IncludeSubCategory">子类</label>
		<%EndIf%>
	</div>
	<div class="ToolBar">
		<input type="checkbox" id="ListByPicture" onClick="ListByPicture_OnClick()" /><label for="ListByPicture">缩略图</label>
		<select id="Sort" onchange="OnSearch()">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
			<option value="5">推荐↓</option>
			<option value="6">推荐↑</option>
			<option value="7">置顶↓</option>
			<option value="8">置顶↑</option>
			<option value="9">序号↓</option>
			<option value="10">序号↑</option>
			<option value="11">顶↓</option>
			<option value="12">顶↑</option>
			<option value="13">踩↓</option>
			<option value="14">踩↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" onkeydown="if(event.keyCode == 13) OnSearch(1);" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input type="button" value="搜索" class="Button" onclick="OnSearch(1)" />
		<input type="button" value="全选" class="Button" onclick="SetCheck('Sel',true)" />
		<input type="button" value="反选" class="Button" onclick="ReverseCheck('Sel')" />
		<span id="ExtraButton"></span>
		<script type="text/javascript">
		MakeButton();
		</script>
	</div>
	<div id="List">
		<ilghar:List ID="List" Object="Product" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" />
		<%If ListByPicture%>
			<ilghar:List Object="Product" Source="List">
				<ilghar:Row MaxCol="4">
					<ul>
						<ilghar:Col MaxRecord="1">
							<ilghar:Record>
								<li>
									<a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><img src="<%=Thumbnail%>" /></a>
									<div class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></div>
								</li>
							</ilghar:Record>
						</ilghar:Col>
					</ul>
				</ilghar:Row>
			</ilghar:List>
		<%Else%>
			<table border="0" cellpadding="4" cellspacing="1">
				<thead>
					<tr>
						<th width="40">选择</th>
						<%If Move%>
							<th width="60">
								<%If Request.QueryString["IsRecommended"] == "true"%>
									移动推荐
								<%Else%>
									移动置顶
								<%EndIf%>
							</th>
						<%EndIf%>
						<th>名称</th>
						<th>价格</th>
						<th width="120">创建时间</th>
						<th width="40">人气</th>
						<th width="40">顶</th>
						<th width="40">踩</th>
					</tr>
				</thead>
				<tbody>
					<ilghar:List Object="Product" Source="List">
						<ilghar:Record>
							<tr id="Row<%=InnerID%>">
								<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
								<%If Move%>
									<td><img onmouseover="this.className+=' Move_MouseOver';" onmouseout="this.className='Move';" name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
								<%EndIf%>
								<td class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
								<td><%=Price%></td>
								<td><%=CreateTime%></td>
								<td><%=HitCount%></td>
								<td><%=Up%></td>
								<td><%=Down%></td>
							</tr>
						</ilghar:Record>
					</ilghar:List>
				</tbody>
			</table>
		<%EndIf%>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>