﻿function BuildHeader()
{
	if (_page == "member_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsLocked=" + $("#IsLocked").val() + "&RoleID=" + $("#RoleID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();

			if (_page == "member_list")
				MakeButton();
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "member_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('Check')\" >" + _lang_check + "</button>";
    	
	    //锁定
	    var obj = $("#IsLocked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('Lock')\" >" + _lang_lock + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMember('UnLock')\" >" + _lang_unlock + "</button>";
	}

	$("#ExtraButton").html(buttons);
}

//-------------------------------------------------
//Start : 性别管理
function AddSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifySex(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSex(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 性别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地区管理
function AddRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyRegion(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteRegion(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveRegion(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 地区管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 行业管理
function AddIndustry()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Industry&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditIndustry()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Industry&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyIndustry(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Industry&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteIndustry(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Industry&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveIndustry(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Industry&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 行业管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 会员管理
function Name_OnChange(e)
{
    if (this.value == "")
        return;

	if (_page == "member_edit" && this.value == _name)
	{
		$("#NameExist").html("");
		return;
	}

	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsNameExist&Name=" + encodeURIComponent(this.value),function(data)
    {
	    if (data.toLowerCase() == "true")
		    $("#NameExist").html(_lang_name_exist);
	    else
		    $("#NameExist").html("");
    });
}

function Email_OnChange(e)
{
    if (this.value == "")
        return;

	if (_page == "member_edit" && this.value == _email)
	{
		$("#EmailExist").html("");
		return;
	}

	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsEmailExist&Email=" + encodeURIComponent(this.value),function(data)
    {
	    if (data.toLowerCase() == "true")
		    $("#EmailExist").html(_lang_email_exist);
	    else
		    $("#EmailExist").html("");
    });
}

function Identity_OnChange(e)
{
    if (this.value == "")
        return;

	if (_page == "member_edit" && this.value == _identity)
	{
		$("#IdentityExist").html("");
		return;
	}

	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsIdentityExist&Identity=" + encodeURIComponent(this.value),function(data)
    {
	    if (data.toLowerCase() == "true")
		    $("#IdentityExist").html(_lang_identity_exist);
	    else
		    $("#IdentityExist").html("");
    });
}

function Member_CheckName(form)
{
	if (_page == "member_edit" && form.Name.value == _name)
	{
		Member_CheckEmail(form);
		return;
	}
	
	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsNameExist&Name=" + encodeURIComponent(form.Name.value),function(data)
    {
	    if (data.toLowerCase() == "true")
			Alert(_lang_name_exist, function(){form.Name.select();}, this);
	    else
		    Member_CheckEmail(form);
    });
}

function Member_CheckEmail(form)
{
	if (_page == "member_edit" && form.Email.value == _email)
	{
		Member_CheckIdentity(form);
		return;
	}
	
	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsEmailExist&Email=" + encodeURIComponent(form.Email.value),function(data)
    {
	    if (data.toLowerCase() == "true")
			Alert(_lang_email_exist, function(){form.Email.select();}, this);
	    else
		    Member_CheckIdentity(form);
    });
}

function Member_CheckIdentity(form)
{
	if (form.Identity.value == "")
	{
		if (_page == "member_edit")
			EditMember_Send(form);
		else
			AddMember_Send(form);
		return;
	}

	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsIdentityExist&Identity=" + encodeURIComponent(form.Identity.value),function(data)
    {
	    if (data.toLowerCase() == "true")
		{
			Alert(_lang_identity_exist, function(){form.Identity.select();}, this);
		}
	    else
		{
			if (_page == "member_edit")
				EditMember_Send(form);
			else
				AddMember_Send(form);
		}
    });
}

function AddMember()
{
	if ($.trim(this.Name.value) == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if ($.trim(this.Password.value) == "")
	{
		Alert(_lang_password_empty, function(){this.Password.select();}, this);
		return false;
	}
	
	if (this.Password.value != this.Confirm.value)
	{
		Alert(_lang_password_confirm, function(){this.Confirm.select();}, this);
		return false;
	}
	
	if (this.PasswordQuestion.value == "")
	{
		Alert(_lang_password_question_empty, function(){this.PasswordQuestion.select();}, this);
		return false;
	}
	
	if (this.PasswordAnswer.value == "")
	{
		Alert(_lang_password_answer_empty, function(){this.PasswordAnswer.select();}, this);
		return false;
	}
	
	if (!this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
	{
		Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (this.Birthday.value != "" && !re.test(this.Birthday.value))
	{
		Alert(_lang_birthday_incorrect, function(){this.Birthday.select();}, this);
		return false;
	}
	
	Member_CheckName(this);

	return false;	
}

function AddMember_Send(form)
{
	_pageID = form.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "IsChecked=true&IsDeleted=false&IsLocked=false&RoleID=" + form.RoleID.value;
	if (typeof(form.CreatorID) != "undefined")
	{
		data += "&CreatorID=" + encodeURIComponent(form.CreatorID.value);
		data += "&Creator=" + encodeURIComponent(form.Creator.value);
	}
	data += "&Name=" + encodeURIComponent(form.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + form.ID.value;
	data += "&Password=" + encodeURIComponent(form.Password.value);
	data += "&PasswordQuestion=" + encodeURIComponent(form.PasswordQuestion.value);
	data += "&PasswordAnswer=" + encodeURIComponent(form.PasswordAnswer.value);
	data += "&Email=" + encodeURIComponent(form.Email.value);
	data += "&Identity=" + encodeURIComponent(form.Identity.value);
	data += "&RealName=" + encodeURIComponent(form.RealName.value);
	if (form.Birthday.value != "")
		data += "&Birthday=" + encodeURIComponent(form.Birthday.value);
	data += "&Phone=" + encodeURIComponent(form.Phone.value);
	data += "&Mobile=" + encodeURIComponent(form.Mobile.value);
	data += "&Address=" + encodeURIComponent(form.Address.value);
	data += "&Zip=" + encodeURIComponent(form.Zip.value);
	data += "&Homepage=" + encodeURIComponent(form.Homepage.value);
	data += "&QQ=" + encodeURIComponent(form.QQ.value);
	data += "&SexID=" + form.SexID.value;
	data += "&RegionID=" + form.RegionID.value;
	data += "&IndustryID=" + form.IndustryID.value;
	data += "&Template=" + encodeURIComponent(form.Template.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddMember_GetInnerID();
		}
	});
}

function AddMember_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member&Operation=GetInnerIDFromGuid&ID=" + _guid,
		type : "GET",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddMember_SetPageID();
		}
	});
}

function AddMember_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditMember()
{
	if ($.trim(this.Name.value) == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PasswordQuestion.value == "")
	{
		Alert(_lang_password_question_empty, function(){this.PasswordQuestion.select();}, this);
		return false;
	}
	
	if (!this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
	{
		Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (this.Birthday.value != "" && !re.test(this.Birthday.value))
	{
		Alert(_lang_birthday_incorrect, function(){this.Birthday.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}

	Member_CheckName(this);

	return false;	
}

function EditMember_Send(form)
{
	var pageID = form.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "RoleID=" + form.RoleID.value;
	data += "&Name=" + encodeURIComponent(form.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + form.ID.value;
	if (form.Password.value != "")
		data += "&Password=" + encodeURIComponent(form.Password.value);
	data += "&PasswordQuestion=" + encodeURIComponent(form.PasswordQuestion.value);
	if (form.PasswordAnswer.value != "")
		data += "&PasswordAnswer=" + encodeURIComponent(form.PasswordAnswer.value);
	data += "&Email=" + encodeURIComponent(form.Email.value);
	data += "&Identity=" + encodeURIComponent(form.Identity.value);
	data += "&RealName=" + encodeURIComponent(form.RealName.value);
	data += "&Birthday=" + encodeURIComponent(form.Birthday.value);
	data += "&Phone=" + encodeURIComponent(form.Phone.value);
	data += "&Mobile=" + encodeURIComponent(form.Mobile.value);
	data += "&Address=" + encodeURIComponent(form.Address.value);
	data += "&Zip=" + encodeURIComponent(form.Zip.value);
	data += "&Homepage=" + encodeURIComponent(form.Homepage.value);
	data += "&QQ=" + encodeURIComponent(form.QQ.value);
	data += "&SexID=" + form.SexID.value;
	data += "&RegionID=" + form.RegionID.value;
	data += "&IndustryID=" + form.IndustryID.value;
	data += "&Template=" + encodeURIComponent(form.Template.value);
	data += "&PageID=" + encodeURIComponent(pageID);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			_name = form.Name.value;
			_email = form.Email.value;
			_identity = form.Identity.value;
		}
	});
}

function UpdateMember(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMember(action, id);}, this);
		else
			UpdateMember(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
			}
		});
	}
}
//End : 会员管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 资金管理
function AddMoney()
{
	if (!this.Amount.value.match(/^-?\d+(\.\d+)?$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (!re.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}

	var data = "MemberID=" + _memberID;
	data += "&Amount=" + this.Amount.value;
	if (parseInt(this.Amount.value) > 0)
	    data += "&Title=" + encodeURIComponent(_userName + _lang_title_plus);
	else
	    data += "&Title=" + encodeURIComponent(_userName + _lang_title_minus);
	data += "&Time=" + encodeURIComponent(this.Time.value);
	data += "&Memo=" + encodeURIComponent(this.Memo.value);
	if (this.PaymentID.value != "")
	{
		data += "&PaymentID=" + encodeURIComponent(this.PaymentID.value);
		data += "&PaymentName=" + encodeURIComponent(this.PaymentID.options[this.PaymentID.selectedIndex].text);
	}
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member.Money&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
		}
	});
	
	return false;
}
//End : 资金管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 积分管理
function AddPoint()
{
	
	if (!this.Amount.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
	if (!re.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}

	var data = "MemberID=" + _memberID;
	data += "&Amount=" + this.Amount.value;
	if (parseInt(this.Amount.value) > 0)
	    data += "&Title=" + encodeURIComponent(_userName + _lang_title_plus);
	else
	    data += "&Title=" + encodeURIComponent(_userName + _lang_title_minus);
	data += "&Time=" + encodeURIComponent(this.Time.value);
	data += "&Memo=" + encodeURIComponent(this.Memo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Member.Point&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
		}
	});
	
	return false;
}
//End : 积分管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	var data = "DefaultRoleID=" + this.DefaultRoleID.value;
	data += "&IsNeedToCheck=" + $("#IsNeedToCheckYes")[0].checked;
	data += "&RegisterAgreement=" + encodeURIComponent(this.RegisterAgreement.value);
	data += "&SendRegisterMail=" + $("#SendRegisterMailYes")[0].checked;
	data += "&RegisterMailSubject=" + encodeURIComponent(this.RegisterMailSubject.value);
	data += "&RegisterMailBody=" + encodeURIComponent(this.RegisterMailBody.value);
	data += "&FindPasswordMailSubject=" + encodeURIComponent(this.FindPasswordMailSubject.value);
	data += "&FindPasswordMailContent=" + encodeURIComponent(this.FindPasswordMailContent.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 服务管理
function AddServer()
{
	if(this.Name.value == "")
	{
		Alert(_lang_name_empty,function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Times.value.match(/^\d+$/))
	{
		Alert(_lang_times_incorrect, function(){this.Times.select();}, this);
		return false;
	}
	
	if (!this.Duration.value.match(/^\d+$/))
	{
		Alert(_lang_duration_incorrect, function(){this.Duration.select();}, this);
		return false;
	}
	
	if (!this.Price.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_price_incorrect, function(){this.Price.select();}, this);
		return false;
	}
	
	if (!this.Point.value.match(/^\d+$/))
	{
		Alert(_lang_point_incorrect, function(){this.Point.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	//会员价格
	_memberPriceIndex = 0;
	_memberPriceAndPoint.length = 0;
	var rows = $("#MemberTable tbody tr");
	for (var i = 0; i < rows.length; i++)
	{
		var checkbox = rows.eq(i).find(":checkbox")[0];
		if (!checkbox.checked)
			continue;

		var textboxes = rows.eq(i).find(":text");

		if (!textboxes.eq(0).val().match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_member_price_incorrect, function(){textboxes[0].select();}, this);
			return false;
		}

		if (!textboxes.eq(1).val().match(/^\d+$/))
		{
			Alert(_lang_member_point_incorrect, function(){textboxes[1].select();}, this);
			return false;
		}
		
		_memberPriceAndPoint.push({LevelID:checkbox.value,Price:textboxes.eq(0).val(),Point:textboxes.eq(1).val()});
	}
	
	
	//代理价格
	_agentPriceIndex = 0;
	_agentPricesAndPoint.length = 0;
	var rows = $("#AgentTable tbody tr");
	for (var i = 0; i < rows.length; i++)
	{
		var checkbox = rows.eq(i).find(":checkbox")[0];
		if (!checkbox.checked)
			continue;

		var textboxes = rows.eq(i).find(":text");

		if (!textboxes.eq(0).val().match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_member_price_incorrect, function(){textboxes[0].select();}, this);
			return false;
		}

		if (!textboxes.eq(1).val().match(/^\d+$/))
		{
			Alert(_lang_member_point_incorrect, function(){textboxes[1].select();}, this);
			return false;
		}
		
		_agentPricesAndPoint.push({LevelID:checkbox.value,Price:textboxes.eq(0).val(),Point:textboxes.eq(1).val()});
	}
	
	
	
}

function AddServer_Send()
{
	
}


//End : 服务管理
//-------------------------------------------------


function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "sex_add")
	{
		$("form:first").submit(AddSex);
	}
	else if (_page == "sex_edit")
	{
		$("form:first").submit(EditSex);
	}
	else if (_page == "sex_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifySex(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSex(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "region_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyRegion(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRegion(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveRegion);
	}
	else if (_page == "region_add")
	{
		$("form").submit(AddRegion);
	}
	else if (_page == "region_edit")
	{
		$("form").submit(EditRegion);
	}
	else if (_page == "industry_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyIndustry(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteIndustry(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveIndustry);
	}
	else if (_page == "industry_add")
	{
		$("form").submit(AddIndustry);
	}
	else if (_page == "industry_edit")
	{
		$("form").submit(EditIndustry);
	}
	else if (_page == "member_add")
	{
		$("form").submit(AddMember);
		$("[name=Name]").change(Name_OnChange);
		$("[name=Identity]").change(Identity_OnChange);
		$("[name=Email]").change(Email_OnChange);
		$("[name=Birthday]").focus(function(){new DatePicker(this);});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "member_edit")
	{
		$("form").submit(EditMember);
		$("[name=Name]").change(Name_OnChange);
		$("[name=Identity]").change(Identity_OnChange);
		$("[name=Email]").change(Email_OnChange);
		$("[name=Birthday]").focus(function(){new DatePicker(this);});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "member_list")
	{
		MakeButton();

		$("#IsRecycled,#IsChecked,#IsLocked,#RoleID,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "member_money_list")
	{
		$("form").submit(AddMoney);
		$("[name=Time]").focus(function(){new DatePicker(this);});
	}
	else if (_page == "member_point_list")
	{
		$("form").submit(AddPoint);
		$("[name=Time]").focus(function(){new DatePicker(this);});
	}
	else if (_page == "config_basic")
	{
		$("form:first").submit(SetBasicSettings);
	}
}
Init();