﻿<%@ Page PathInChannel="{ID}{Page}{Ext}" Object="Info" %>
<%@ OutputCache Duration="86400" VaryByParam="none" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Info" Object="Info" PageID="Request.QueryString['ID']" ForMeta="true" />
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="keywords" content="<%=MetaKeywords%>" />
<meta name="description" content="<%=MetaDescription%>" />
<title><%=Info[Title]%> - <%=Info[CategoryName]%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" type="text/css" href="<%=CssPath%>common.css" />
<script type="text/javascript">
var _page = "info";
var _webPath = "<%=WebPath%>";
var _id = "<%=Info[InnerID]%>";
var _guid = "<%=Info[ID]%>";
var _commentPage = "<%=BuildUrl("ajax_comment")%>";
var _checkComment = <%=Config[CheckComment]%>;
var _addPage = "<%=BuildUrl("add")%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_login_fail = "登陆失败！请检查你的用户名和密码是否正确！";
var _lang_name_empty = "会员名不能为空！";
var _lang_password_empty = "密码不能为空！";
var _lang_content_empty = "内容不能为空！";
</script>
</head>
<body>
<div class="Wrap TopMenu">
	<ul>
		<li class="Bg1"><a href="<%=BuildUrl("add")%>">发布信息</a></li>
	</ul>
	<div>
		<form action="">
			用户名：<input type="text" name="Name" />
			密码：<input type="password" name="Password" />
			<input type="submit" class="Submit" value="登录" />
		</form>
		<p><span></span> 欢迎您！</p>
	</div>
	<ol>
		<li class="Bg2"><a href="<%=BuildUrl("Member", "login")%>">登录</a></li>
		<li class="Bg1"><a href="<%=BuildUrl("Member", "register")%>">注册</a></li>
		<li style="display:none"><a href="<%=BuildUrl("Member", "index")%>">会员面板</a></li>
		<li style="display:none"><a href="<%=BuildUrl("Member", "logout")%>">安全退出</a></li>
	</ol>
</div>

<div class="Wrap Header">
	<div><a href="<%=WebPath%>"><img src="<%=Logo%>" alt="<%=Site[Name]%>" /></a></div>
	<form action="<%=BuildUrl("search")%>">
		<input type="text" name="q" class="<%=PageLang%>Font" />
		<input type="submit" value="搜 索" class="Submit" />
		<input type="button" value="发布信息" class="Button" />
	</form>
</div>

<div class="Wrap Menu">
	<!-- TemplateBeginEditable name="主菜单" -->
	<ilghar:Menu Condition="IsDisplay=true and CategoryID IS NULL and ParentID IS NULL">
		<ul>
			<ilghar:Record>
				<ilghar:Select>
					<ilghar:Yes>
						<li class="Selected"><a><span><%=Name%></span></a></li>
					</ilghar:Yes>
					<ilghar:No>
						<li><a href="<%=URL%>" target="<%=Target%>" title="<%=Name%>"<%=Style%>><span><%=Name%></span></a></li>
					</ilghar:No>
				</ilghar:Select>
			</ilghar:Record>
		</ul>
	</ilghar:Menu>
	<!-- TemplateEndEditable -->
	<!-- TemplateBeginEditable name="子菜单" -->
	<ilghar:List Object="Region" Condition="ParentID IS NULL">
		<ol>
			<ilghar:Record>
				<li><a href="<%=BuildUrl("region")%>"><%=Name%></a></li>
				<ilghar:Separator>
					<li class="Separator"></li>
				</ilghar:Separator>
			</ilghar:Record>
		</ol>
	</ilghar:List>
	<!-- TemplateEndEditable -->
</div>

<div class="Wrap">
	<!-- TemplateBeginEditable name="广告位：分类信息 - 菜单下方 - 左" -->
	<div class="Ad1">
		<ilghar:Ad Guid="{133F6304-0A94-4DC5-B251-154FEED61BB8}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/1.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
	<!-- TemplateBeginEditable name="广告位：分类信息 - 菜单下方 - 中" -->
	<div class="Ad2">
		<ilghar:Ad Guid="{C30B1018-8CA5-426C-B683-F54B46A0A3C1}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/2.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
	<!-- TemplateBeginEditable name="广告位：分类信息 - 菜单下方 - 右" -->
	<div class="Ad3">
		<ilghar:Ad Guid="{C209EE3A-149B-4115-BFD2-867861F23C1F}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/3.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
</div>

<!-- TemplateBeginEditable name="路径" -->
<div class="Wrap">
	<div class="Path">
		当前位置：
		<ilghar:Path Object="Category" Guid="Info[CategoryID]">
			<ilghar:Record>
				<a href="<%=URL%>"><%=Name%></a> &gt;
			</ilghar:Record>
		</ilghar:Path>
		<%=Info[Title]%>
	</div>
</div>
<!-- TemplateEndEditable -->

<div class="Wrap Block4">
	<div class="Main">
		<!-- TemplateBeginEditable name="信息内容" -->
		<h1 class="Title"><%=Info[Title]%>(人气：<span id="HitCount"></span>)</h1>
		<div class="Content">
			<%=Info[Content]%>
			<ul class="Info">
				<li>联系人：<%=Info[Name]%></li>
				<li>电话：<%=Info[Phone]%></li>
				<li>手机：<%=Info[Mobile]%></li>
				<li>地区：<%=Info[RegionName]%></li>
				<li>类别：<%=Info[CategoryName]%></li>
				<li>发布时间：<%=Info[UpdateTime]%></li>
				<li>过期时间：<%=Info[ExpirationTime]%></li>
			</ul>
		</div>
		<!-- TemplateEndEditable -->

		<h1 class="Title">评论</h1>
		<div class="Comment">
			<!-- TemplateBeginEditable name="评论列表" -->
			<div>
			</div>
			<!-- TemplateEndEditable -->
			
			<%If Convert.ToBoolean(Config[EnableComment])%>
				<form action="">
					<table>
						<thead>
							<tr>
								<td>发表评论</td>
							</tr>
						</thead>
						<tfoot>
							<tr>
								<td>
									<input type="submit" value="提交" />
									<label>
										名称：<input type="text" size="20" name="Name" class="CHSFont" />
									</label>
								</td>
							</tr>
						</tfoot>
						<tbody>
							<tr>
								<td><textarea name="Content" rows="5" cols="60" class="CHSFont"></textarea><input type="hidden" name="Title" value="<%=Info[Title]%>" /></td>
							</tr>
						</tbody>
					</table>
				</form>
			<%EndIf%>
		</div>
		
	</div>
	<div class="Side">
		<!-- TemplateBeginEditable name="信息类别" -->
		<ilghar:List Object="Category" Condition="IsDisplay=true and ParentID IS NULL">
			<dl>
				<dt><span>信息类别</span></dt>
				<ilghar:Record>
					<dd><a href="<%=BuildUrl()%>"><%=Name%></a></dd>
				</ilghar:Record>
			</dl>
		</ilghar:List>
		<!-- TemplateEndEditable -->
		
		<!-- TemplateBeginEditable name="广告位：分类信息 - 侧栏底部" -->
		<ilghar:Ad Guid="{B1D3387A-C51F-4D7D-878C-82670EC084B8}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/4.gif" alt="Ad" style="width:236px;height:236px" /></a>
		</ilghar:Ad>
		<!-- TemplateEndEditable -->
	</div>
</div>

<div class="Wrap">
	<!-- TemplateBeginEditable name="广告位：分类信息 - 页面底部 - 左" -->
	<div class="Ad1">
		<ilghar:Ad Guid="{9FA73A3E-69DB-43EF-A6BB-4E72499C0AA9}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/1.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
	<!-- TemplateBeginEditable name="广告位：分类信息 - 页面底部 - 中" -->
	<div class="Ad2">
		<ilghar:Ad Guid="{DBFCAA75-674C-45EA-A4FC-CAF0BFD9E087}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/2.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
	<!-- TemplateBeginEditable name="广告位：分类信息 - 页面底部 - 右" -->
	<div class="Ad3">
		<ilghar:Ad Guid="{5F780B5C-DAE4-4180-9F7F-E2EC3B2E9069}">
			<a href="http://www.ilghar.cn/" target="_blank"><img src="<%=ImagePath%>ad/3.gif" style="width:320px;height:75px" /></a>
		</ilghar:Ad>
	</div>
	<!-- TemplateEndEditable -->
</div>

<!-- TemplateBeginEditable name="友情链接" -->
<div class="Wrap">
	<div class="Link">
		<h1>友情链接</h1>
		<ilghar:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NOT NULL">
			<ul>
				<ilghar:Record>
					<li><a href="<%=URL%>" target="_blank"><img src="<%=Logo%>" alt="<%=Name%>" /></a></li>
				</ilghar:Record>
			</ul>
		</ilghar:List>
		<ilghar:List Mark="System" Object="Link" Condition="IsChecked=true and Logo IS NULL">
			<ol>
				<ilghar:Record>
					<li><a href="<%=URL%>" target="_blank"><%=Name%></a></li>
				</ilghar:Record>
			</ol>
		</ilghar:List>
	</div>
</div>
<!-- TemplateEndEditable -->

<!-- TemplateBeginEditable name="脚注菜单" -->
<ilghar:Menu Condition="IsDisplay=true and CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
	<div class="Wrap FooterMenu">
		<ilghar:Record>
			<a href="<%=URL%>" target="<%=Target%>" title="<%=Name%>"<%=Style%>><%=Name%></a>
			<ilghar:Separator>|</ilghar:Separator>
		</ilghar:Record>
	</div>
</ilghar:Menu>
<!-- TemplateEndEditable -->

<!-- TemplateBeginEditable name="脚注" -->
<div class="Wrap Footer">
	<%=Footer%>
</div>
<!-- TemplateEndEditable -->

<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<%=StatisticsCode%>
</body>
</html>
