using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Configuration;

namespace FOUPOS.DBUtility
{
    /// <summary>
    /// ṩҪʹõһЩ֤߼
    /// </summary>
    public class Validator
    {
        /// <summary>
        /// һַǷתΪڣһ֤ûڵĺϷԡ
        /// </summary>
        /// <param name="_value">ַ֤</param>
        /// <returns>ǷתΪڵboolֵ</returns>
        public static bool IsStringDate(string _value)
        {
            DateTime dt;
            try
            {
                dt = DateTime.Parse(_value);
            }
            catch (FormatException e)
            {
                //ڸʽȷʱ
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        /// <summary>
        /// һַǷǴֹɵģһڲѯַЧ֤
        /// </summary>
        /// <param name="_value">ַ֤</param>
        /// <returns>ǷϷboolֵ</returns>
        public static bool IsNumberId(string _value)
        {
            return Validator.QuickValidate("^[1-9]*[0-9]*$", _value);
        }

        /// <summary>
        /// һַǷǴĸֹɵģһڲѯַЧ֤
        /// </summary>
        /// <param name="_value">ַ֤</param>
        /// <returns>ǷϷboolֵ</returns>
        public static bool IsLetterOrNumber(string _value)
        {
            return Validator.QuickValidate("^[a-zA-Z0-9_]*$", _value);
        }

        /// <summary>
        /// жǷ֣С
        /// </summary>
        /// <param name="_value">ַ֤</param>
        /// <returns>ǷϷboolֵ</returns>
        public static bool IsNumber(string _value)
        {
            return Validator.QuickValidate("^(0|([1-9]+[0-9]*))(.[0-9]+)?$", _value);
        }

        /// <summary>
        /// ֤һַǷָʽ
        /// </summary>
        /// <param name="_express">ʽݡ</param>
        /// <param name="_value">ַ֤</param>
        /// <returns>ǷϷboolֵ</returns>
        public static bool QuickValidate(string _express, string _value)
        {
            System.Text.RegularExpressions.Regex myRegex = new System.Text.RegularExpressions.Regex(_express);
            if (_value.Length == 0)
            {
                return false;
            }
            return myRegex.IsMatch(_value);
        }
        /// <summary>
        /// ֻĺϷ
        /// </summary>
        /// <param name="M"></param>
        /// <returns></returns>
        public static bool TelCheck(string M)
        {
            //	\d{4}\-\d{8}|
            try
            {
                long.Parse(M);
            }
            catch
            {
                return false;
            }
            RegexOptions options = RegexOptions.Multiline;
            Regex regex = new Regex(@"13\d{9}|159\d{8}|01\d{9}|02\d{9}|0[^1-2]\d{9}|0[^1-2]\d{10}", options);
            bool isMatch = regex.IsMatch(M);
            return isMatch;
        }
        /// <summary>
        /// ַΪջ߿ոʱصֵ
        /// </summary>
        /// <param name="str"></param>
        /// <param name="Result"></param>
        /// <returns></returns>
        public static string StringTryConvert(System.DBNull str, string Result)
        {
            return Result;
        }

        public static string StringTryConvert(string str, string Result)
        {
            if (str != null && str != "")
            {
                return str;
            }
            else
            {
                return Result;
            }
        }

        /// <summary>
        /// ˣӣѣ̷Ƿַ
        /// </summary>
        /// <param name="SqlStr"></param>
        /// <returns></returns>
        public static string SqlStrCheck(string SqlStr)
        {
            return SqlStr.Replace("'", "");
        }

        //ظGUID
        public static string Str_GetGUID()
        {
            string RtnStr = "";
            Guid guid = Guid.NewGuid();
            uint GuidHashCode = (uint)guid.GetHashCode();
            RtnStr = GuidHashCode.ToString();
            return RtnStr;
        }

    }
}
