﻿// ===============================================================================
//  解决方案：网鸟Asp.Net模板引擎
//  项目名称：MyWebsite
//  文件名称：MultiLanguageEngine.cs
//  代码作者：网鸟老兵团(Me.YMind)
//  创建时间：2011-06-17 21:12
// ===============================================================================
//  Copyright © Htmlbird.Net. All rights reserved .
//  官方网站：http://www.htmlbird.net/
//  技术论坛：http://bbs.htmlbird.net/
//  版权所有：网鸟IT技术论坛 颜铭工作室
// ===============================================================================

using System;
using System.Text;
using Net.Htmlbird.TemplateEngine;
using Net.Htmlbird.TemplateEngine.Tags;

namespace MyWebsite
{
	public sealed class MultiLanguageEngine : MultiLanguageEngineBase
	{
		public MultiLanguageEngine(string languagePath, string languageCode) : base(languagePath, languageCode) { }
	}

	public sealed class RedirectTag : StatementElement
	{
		public RedirectTag(string prefix, int line, int column) : base(prefix, "redirect", line, column) {}

		public string Url { get { return this.GetAttributeValue("url"); } }

		public override string ToAspx()
		{
			var indentBlank = this.IndentBlank;
			var aspx = new StringBuilder();

			aspx.AppendFormat(@"{2}{2}<%{0}Response.Redirect(""{1}"");%>{2}{2}", indentBlank, this.Url, Environment.NewLine);

			return aspx.ToString();
		}
	}
}