﻿// ===============================================================================
//  解决方案：网鸟Asp.Net模板引擎
//  项目名称：MyWebsite
//  文件名称：Page1.cs
//  代码作者：网鸟老兵团(Me.YMind)
//  创建时间：2011-06-17 20:06
// ===============================================================================
//  Copyright © Htmlbird.Net. All rights reserved .
//  官方网站：http://www.htmlbird.net/
//  技术论坛：http://bbs.htmlbird.net/
//  版权所有：网鸟IT技术论坛 颜铭工作室
// ===============================================================================

using System;
using System.Web.Caching;
using System.Web.UI;
using Net.Htmlbird.TemplateEngine;

namespace MyWebsite.WebUI
{
	public class Page1 : Page, IMultiLanguage
	{
		public MyObjectInfo MyObject { get; private set; }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);

			this.MyObject = new MyObjectInfo {
				Id = Guid.NewGuid(),
				Name = "我的实体对象"
			};
		}

		#region IMultiLanguage Members

		/// <summary>
		/// 获取用于网鸟Asp.Net模板引擎生成的代码的多语言引擎的实例。
		/// </summary>
		public MultiLanguageEngineBase Language
		{
			get
			{
				const string cacheName = "HtmlbirdPortal_MultiLanguageEngine";
				var language = Cache.Get(cacheName) as MultiLanguageEngine;

				if (language == null)
				{
					language = new MultiLanguageEngine(this.LanguagesPath, this.LanguageCode);

					Cache.Add(cacheName, language, null, DateTime.MaxValue, TimeSpan.Zero, CacheItemPriority.Normal, null);
				}

				return language;
			}
		}

		/// <summary>
		/// 获取语言包所在的路径。
		/// </summary>
		public string LanguagesPath
		{
			get { return Server.MapPath("~/Languages"); }
		}

		/// <summary>
		/// 获取当前正在使用的语言类型的代码。
		/// </summary>
		public string LanguageCode { get { return "zh-CHS"; } }

		/// <summary>
		/// 重置到默认语言类型。
		/// </summary>
		public void ResetLanguage() { this.Language.LanguageCode = this.LanguageCode; }

		#endregion
	}
}