﻿// ===============================================================================
//  解决方案：网鸟Asp.Net模板引擎
//  项目名称：MyWebsite
//  文件名称：Page2.cs
//  代码作者：网鸟老兵团(Me.YMind)
//  创建时间：2011-06-17 20:49
// ===============================================================================
//  Copyright © Htmlbird.Net. All rights reserved .
//  官方网站：http://www.htmlbird.net/
//  技术论坛：http://bbs.htmlbird.net/
//  版权所有：网鸟IT技术论坛 颜铭工作室
// ===============================================================================

using System;
using System.IO;
using System.Text;
using Net.Htmlbird.TemplateEngine;

namespace MyWebsite.WebUI
{
	public class Page2 : Page1, ISDEHandler
	{
		#region ISDEHandler Members

		/// <summary>
		/// 获取或设置保存文件时使用的字符编码。
		/// </summary>
		public Encoding TextEncoding { get { return Encoding.UTF8; } }

		/// <summary>
		/// 获取或设置静态文件的有效期。
		/// </summary>
		public TimeSpan ExpirationTime { get; set; }

		/// <summary>
		/// 获取或设置静态文件的完整文件名（相对于应用程序根目录）。
		/// </summary>
		public string StaticFileName { get; set; }

		/// <summary>
		/// 获取或设置动态文件的完整文件名（相对于应用程序根目录）。
		/// </summary>
		public string DynamicFileName { get; set; }

		/// <summary>
		/// 执行动静平衡支持程序。
		/// </summary>
		/// <returns>如果静态文件不需要更新且已经成功切换到并运行了静态文件，则返回 true；否则返回 false。</returns>
		public bool ExecuteSDE()
		{
			// 当然，您可以再根据文件的最后更新日期实现更加复杂的SDE
			// 这里只是一个简单的演示，实现的是当静态文件存在的时候就直接采用静态文件
			if (File.Exists(this.StaticFileName))
			{
				try
				{
					this.Response.HeaderEncoding = Encoding.UTF8;

					this.Server.Transfer(this.StaticFileName);
				}
				catch
				{
					return false;
				}

				return true;
			}

			return false;
		}

		/// <summary>
		/// 更新静态文件。
		/// </summary>
		/// <param name="document">包含了已经生成的静态文件的文档代码的字符串。</param>
		public void UpdateStaticFile(StringBuilder document) { File.WriteAllText(this.StaticFileName, document.ToString(), Encoding.UTF8); }

		#endregion

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);

			this.ExpirationTime = TimeSpan.MaxValue;
			this.StaticFileName = this.Server.MapPath("~/Cache/Page2/temp.html");
			this.DynamicFileName = this.Server.MapPath("~/Aspx/2.aspx");
		}
	}
}