using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;

namespace DAL
{
    public static class DBHelper
    {
        private static SqlConnection connection;

        public static SqlConnection Connection
        {
            get
            {
                string connectionString = "Data Source=.;Initial Catalog=RoleData;User ID=sa;Pwd=123";
                //string connectionString = ConfigurationManager.ConnectionStrings["XOA"].ToString();
                if (connection == null)
                {
                    connection = new SqlConnection(connectionString);
                    connection.Open();
                }
                else if (connection.State == ConnectionState.Closed)
                {
                    connection.Open();
                }
                else if (connection.State == ConnectionState.Broken)
                {
                    connection.Close();
                    connection.Open();
                }
                return connection;
            }

        }
        /// <summary>
        /// ִ޲εsql
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static int ExecuteCommand(string sql)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            int result = command.ExecuteNonQuery();
            return result;
        }
        /// <summary>
        /// ִдεsql
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="values"></param>
        /// <returns></returns>
        public static int ExecuteCommand(string sql, params SqlParameter[] values)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            command.Parameters.AddRange(values);
            int result = command.ExecuteNonQuery();
            return result;
        }
        /// <summary>
        /// ִ޲sql䣬زѯ¼
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static int GetScalar(string sql)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            return Convert.ToInt32(command.ExecuteScalar());
        }
        /// <summary>
        /// ִдsql䣬زѯ¼
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="values"></param>
        /// <returns></returns>
        public static int GetScalar(string sql, params SqlParameter[] values)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            command.Parameters.AddRange(values);
            return Convert.ToInt32(command.ExecuteScalar());
        }
        /// <summary>
        /// ִ޲sql䣬Reader
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static SqlDataReader GetReader(string sql)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            SqlDataReader Reader = command.ExecuteReader();
            return Reader;
        }
        /// <summary>
        /// ִвsql䣬Reader
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="values"></param>
        /// <returns></returns>
        public static SqlDataReader GetReader(string sql, params SqlParameter[] values)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            command.Parameters.AddRange(values);
            SqlDataReader Reader = command.ExecuteReader();
            return Reader;
        }
        public static DataTable GetDataSet(string safeSql)
        {
            DataSet ds = new DataSet();
            SqlCommand cmd = new SqlCommand(safeSql, Connection);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            da.Fill(ds);
            return ds.Tables[0];
        }

        public static DataTable GetDataSet(string sql, params SqlParameter[] values)
        {
            DataSet ds = new DataSet();
            SqlCommand cmd = new SqlCommand(sql, Connection);
            cmd.Parameters.AddRange(values);
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            da.Fill(ds);
            return ds.Tables[0];
        }


        public static object XluoGetScalar(string sql)
        {
            SqlCommand command = new SqlCommand(sql, Connection);
            return command.ExecuteScalar();
        }

    }
}
