﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using BLL;
using Models;

public partial class UserInfoManager : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            gvBind();
            ddlBind();
        }
    }

    private void gvBind()
    {
        gvUserInfo.DataSource = UsersManager.show();
        gvUserInfo.DataBind();
    }
    protected void btnAddUser_Click(object sender, EventArgs e)
    {
        UserInfo users = new UserInfo();
        users.UName = txtUName.Text;
        users.UPwd = txtUPwd.Text;
        users.URole = Convert.ToInt32(ddlURole.SelectedItem.Value);
        bool bl = UsersManager.add(users);
        if (bl)
        {
            Response.Redirect("UserInfoManager.aspx");
        }
        else
        {
            Response.Redirect("Error.aspx");
        }
    }
    protected void btnReset_Click(object sender, EventArgs e)
    {
        txtUName.Text = "";
        txtUPwd.Text = "";
    }
    protected void gvUserInfo_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {

    }
    protected void gvUserInfo_RowEditing(object sender, GridViewEditEventArgs e)
    {

    }

    public void ddlBind()
    {
        ddlURole.DataSource = RoleManager.show();
        ddlURole.DataBind();
    }

    public object readRoleById(object id)
    {
        return RoleManager.ReadNameById(Convert.ToInt32(id));
    }
    protected void gvUserInfo_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {

    }
}
