using System;
using System.Data;
using System.Data.OleDb;
using System.Configuration;

namespace QYTang.Gengerate
{
    /// <summary>
    /// OleDb
    /// </summary>
    public abstract class OpOleDb
    {
        /// <summary>
        /// ȡݿѯַ
        /// </summary>
        public static string connStr = ConfigurationManager.ConnectionStrings["QYTangConnectionString"].ToString();

        /// <summary>
        /// һsql,ȡDataset
        /// </summary>
        /// <param name="con">ݿַ</param>
        /// <param name="cmdText">sql</param>
        /// <param name="parms">б</param>
        /// <returns>Dataset</returns>
        public static DataSet GetDataSet(string con, string cmdText, OleDbParameter[] parms)
        {
            DataSet ds = new DataSet();
            OleDbCommand cmd = new OleDbCommand();
            OleDbConnection conn = new OleDbConnection(con);
            OleDbDataAdapter da = new OleDbDataAdapter();
            PrepareCommand(cmd, conn, CommandType.Text, cmdText, parms);
            da.SelectCommand = cmd;
            da.Fill(ds);
            cmd.Parameters.Clear();
            if (conn.State == ConnectionState.Open)
                conn.Close();
            return ds;
        }

        /// <summary>
        /// ȡDataReader
        /// </summary>
        /// <param name="con">ݿַ</param>
        /// <param name="cmdText">sql</param>
        /// <param name="parms">б</param>
        /// <returns>DataReader</returns>
        public static OleDbDataReader GetDataRead(OleDbConnection conn, string cmdText, OleDbParameter[] parms)
        {
            OleDbCommand cmd = new OleDbCommand();
            PrepareCommand(cmd, conn, CommandType.Text, cmdText, parms);
            OleDbDataReader dr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            cmd.Parameters.Clear();
            return dr;
        }

        /// <summary>
        /// 롢»ɾ
        /// </summary>
        /// <param name="con">ݿַ</param>
        /// <param name="cmdText">sql</param>
        /// <param name="parms">б</param>
        /// <returns>ܵ </returns>
        public static int Query(string con, string cmdText, OleDbParameter[] parms)
        {
            OleDbCommand cmd = new OleDbCommand();
            OleDbConnection conn = new OleDbConnection(con);
            PrepareCommand(cmd, conn, CommandType.Text, cmdText, parms);
            int val = cmd.ExecuteNonQuery();
            cmd.Parameters.Clear();
            if (conn.State == ConnectionState.Open)
                conn.Close();
            return val;
        }

        // Ϊݲѯ׼
        static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, CommandType cmdType, string cmdText, OleDbParameter[] parms)
        {
            if (conn.State != ConnectionState.Open)
                conn.Open();
            cmd.Connection = conn;
            cmd.CommandText = cmdText;
            cmd.CommandType = cmdType;
            if (parms != null)
            {
                for (int i = 0; i < parms.Length; i++)
                    cmd.Parameters.Add(parms[i]);
            }
        }
    }
}
