﻿CREATE DATABASE [JumbotCMS]
 COLLATE Chinese_PRC_CI_AS
GO

exec sp_dboption N'JumbotCMS', N'autoclose', N'true'
GO

exec sp_dboption N'JumbotCMS', N'bulkcopy', N'false'
GO

exec sp_dboption N'JumbotCMS', N'trunc. log', N'true'
GO

exec sp_dboption N'JumbotCMS', N'torn page detection', N'true'
GO

exec sp_dboption N'JumbotCMS', N'read only', N'false'
GO

exec sp_dboption N'JumbotCMS', N'dbo use', N'false'
GO

exec sp_dboption N'JumbotCMS', N'single', N'false'
GO

exec sp_dboption N'JumbotCMS', N'autoshrink', N'true'
GO

exec sp_dboption N'JumbotCMS', N'ANSI null default', N'false'
GO

exec sp_dboption N'JumbotCMS', N'recursive triggers', N'false'
GO

exec sp_dboption N'JumbotCMS', N'ANSI nulls', N'false'
GO

exec sp_dboption N'JumbotCMS', N'concat null yields null', N'false'
GO

exec sp_dboption N'JumbotCMS', N'cursor close on commit', N'false'
GO

exec sp_dboption N'JumbotCMS', N'default to local cursor', N'false'
GO

exec sp_dboption N'JumbotCMS', N'quoted identifier', N'false'
GO

exec sp_dboption N'JumbotCMS', N'ANSI warnings', N'false'
GO

exec sp_dboption N'JumbotCMS', N'auto create statistics', N'true'
GO

exec sp_dboption N'JumbotCMS', N'auto update statistics', N'true'
GO

if( (@@microsoftversion / power(2, 24) = 8) and (@@microsoftversion & 0xffff >= 724) )
	exec sp_dboption N'JumbotCMS', N'db chaining', N'false'
GO

use [JumbotCMS]
GO

if not exists (select * from master.dbo.syslogins where loginname = N'JumbotCMS')
BEGIN
	declare @logindb nvarchar(132), @loginlang nvarchar(132) select @logindb = N'master', @loginlang = N'简体中文'
	if @logindb is null or not exists (select * from master.dbo.sysdatabases where name = @logindb)
		select @logindb = N'master'
	if @loginlang is null or (not exists (select * from master.dbo.syslanguages where name = @loginlang) and @loginlang <> N'us_english')
		select @loginlang = @@language
	exec sp_addlogin N'JumbotCMS', 'JumbotCMS', @logindb, @loginlang
END
GO
if not exists (select * from dbo.sysusers where name = N'JumbotCMS')
	EXEC sp_grantdbaccess N'JumbotCMS', N'JumbotCMS'
GO
exec sp_addrolemember N'db_owner', N'JumbotCMS'
GO