﻿//JumbotCms!NET_V2.5.1215;
function oAjax(url ,callback)
{
        try{
                this.HttpRequest = null;
                this.Debug  = false;
                this.Url = url;
                this.ContentType = "text/xml";
                this.HttpRequest = this.createXMLHttpRequest();

                if (this.HttpRequest == null)
                {
                        this._debug("XMLHttpRequest create failure!");
                        return;
                }

                var xhReq = this.HttpRequest;
                xhReq.onreadystatechange = function (){
                        oAjax._OnReadyStateChange(xhReq,callback);
                }

        }
        catch(e){
                this._debug("unknow err: " + e.message);
        }
}

oAjax.prototype.Get = function()
{
        this.SetContentType("text/html");
        this._get();
}

oAjax.prototype.Post = function(arrKey, arrValue)
{
        var data = '';
        this.SetContentType("application/x-www-form-urlencoded");
        for(i = 0; i < arrKey.length; i ++)
        {
                data += "&" + escape(arrKey[i]) + "=" + escape(unescape(arrValue[i]));
        }
        data = data.replace(/^&/g, "");
        this._post(data);
}

oAjax.prototype.Init = function()
{
        // initialization
}

oAjax.prototype.SetUrl = function(url)
{
        this.Url = url;
}

oAjax.prototype.SetContentType = function(type)
{
        this.ContentType = type;
}

oAjax.prototype.createXMLHttpRequest = function()
{
        try { return new ActiveXObject("Msxml2.XMLHTTP"); } catch(e) {}
        try { return new ActiveXObject("Microsoft.XMLHTTP"); } catch(e) {}
        try { return new XMLHttpRequest(); } catch(e) {}
        return null;
}

oAjax.prototype._debug = function(message) {
        if (this.Debug)
        {
                alert(message);
        }
}

oAjax._OnReadyStateChange = function(xreq, callback){
        if (xreq == null)
        {
                return;
        }
        if (xreq.readyState == 4)
        {          
                if (xreq.status == 200)
                {
                        callback (this.ArrayValue(xreq.responseXML));                                         
                }
                else{
                        document.write (xreq.responseText);
                }
        }
        else {
        }
}

oAjax.prototype._SendRequest = function(HttpMethod, data)
{
        this._debug('Send Request ' + HttpMethod + data);
        if (this.HttpRequest != null)
        {
                this.HttpRequest.open(HttpMethod, this.Url, true);
                if (this.ContentType != null)
                {
                        this.HttpRequest.setRequestHeader("content-type", this.ContentType);
                }
                this.HttpRequest.send(data);
                return true;
        }
        return false;
}

oAjax.prototype._get = function()
{
        this._debug('GET');
        return this._SendRequest("GET", null);
}

oAjax.prototype._post = function (data)
{
        this._debug('POST');
        return this._SendRequest("POST", data);
}

oAjax.ArrayValue = function(xmlobj)
{
        var array = new Array();
        var i = 0;
        var response = xmlobj.getElementsByTagName('Response')[0];
        var element = response.firstChild;
        array[i] = element.firstChild.nodeValue;
        while (element = element.nextSibling)
        {
                i ++;
                array[i] = element.firstChild.nodeValue;
        }
        return array;
}