using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
using Model;

namespace BLL
{
    public class Book : IBLL.IBook
    {
        #region IBook Ա

        IDAL.IBook dal = DALFactory.DataAccess.CreateBook();


        /// <summary>
        /// ȡָ¼
        /// </summary>
        /// <param name="count">¼</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetTopBookList(int count)
        {
            return dal.SelectTopBookList(count);
        }

        /// <summary>
        /// ȡ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookList(Model.PagerParameter pager)
        {
            return dal.BookList(pager);
        }

        /// <summary>
        /// ȡ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetAllBook(Model.PagerParameter pager)
        {
            return dal.SelectAllBook(pager);
        }

        /// <summary>
        /// ͨ鼮Idȡ鼮
        /// </summary>
        /// <param name="bookId">鼮ID</param>
        /// <returns>Model.Book</returns>
        public Model.Book GetBookById(int bookId)
        {
            return dal.SelectBookById(bookId);
        }

        /// <summary>
        /// ͨ鼮ȡ鼮
        /// </summary>
        /// <param name="title">鼮</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookByTitle(string title, Model.PagerParameter pager)
        {
            return dal.SelectBookByTitle(title, pager);
        }

        /// <summary>
        /// ͨûȡ鼮
        /// </summary>
        /// <param name="userName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookByUser(string userName, Model.PagerParameter pager)
        {
            return dal.SelectBookByUser(userName, pager);
        }

        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="book">Model.Book,鼮ʱĲ</param>
        /// <returns>ӵ鼮</returns>
        public int AddBook(Model.Book book)
        {
            return dal.InsertBook(book);
        }

        /// <summary>
        /// 鼮ɾ鼮
        /// </summary>
        /// <param name="bookId">鼮</param>
        /// <returns>ɾ鼮</returns>
        public int RemoveBook(int bookId)
        {
            return dal.DeleteBook(bookId);
        }

        /// <summary>
        /// ͨIdȡ鼮
        /// </summary>
        /// <param name="categoryId">ID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookListByCategoryId(int categoryId, Model.PagerParameter pager)
        {
            return dal.SelectBookListByCategoryId(categoryId, pager);
        }

        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="book">Model.Book,鼮ϢʱĲ</param>
        /// <returns>ظ鼮</returns>
        public int ModifyBook(Model.Book book)
        {
            return dal.UpdateBook(book);
        }

        /// <summary>
        /// ͨidȡ鼮
        /// </summary>
        /// <param name="bigCategoryID"></param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookByCategoryId(int bigCategoryID, Model.PagerParameter pager)
        {
            return dal.SelectBookByCategoryId(bigCategoryID, pager);
        }

        /// <summary>
        /// ͨ鼮źûȡ鼮Ϣ
        /// </summary>
        /// <param name="bigCategoryID"></param>
        /// <param name="UserName">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookByCategoryId_UserName(int bigCategoryID, string UserName, Model.PagerParameter pager)
        {
            return dal.SelectBookByCategoryId_UserName(bigCategoryID, UserName, pager);
        }

        /// <summary>
        /// ͨ߻ȡ鼮
        /// </summary>
        /// <param name="author">û</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookByAuthor(string author, Model.PagerParameter pager)
        {
            return dal.SelectBookByAuthor(author, pager);
        }
        /// <summary>
        /// ȡ鼮Ϣ
        /// </summary>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetAllBook()
        {
            return dal.SelectAllBook();
        }

        /// <summary>
        /// 鼮ģȡ鼮
        /// </summary>
        /// <param name="title">鼮</param>
        /// <returns>IList<Model.Book>ͼ</returns>
        public IList<Model.Book> GetBookWithTitle(string title)
        {
            return dal.SelectBookWithTitle(title);
        }

        /// <summary>
        /// ݷidȡ鼮
        /// </summary>
        /// <param name="VolumeId"></param>
        /// <returns>鼮</returns>
        public string GetBookName(int VolumeId)
        {
            SqlParameter parm = new SqlParameter("@VolumeId", SqlDbType.Int);
            parm.Value = VolumeId;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure,
                                                        "Tengfei_SelectBookNameByVolumeId", parm);
            sdr.Read();
            return sdr.GetString(0);
        }
       

        public int TotalClick(int bookId)
        {
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = bookId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_TotalClick", parm);
        }

        public int RecdNum(int bookId)
        {
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = bookId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_RecdNum", parm);
        }
        public int CollectionNum(int bookId)
        {
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = bookId;
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_CollectionNum", parm);
        }
        public SqlDataReader GetFavouriteBookByUser(string userName, PagerParameter pager)
        {
            SqlParameter[] parm ={new SqlParameter("@UserName",SqlDbType.NVarChar),
                                  new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            parm[0].Value = userName;
            parm[1].Value = pager.StartIndex;
            parm[2].Value = pager.EndIndex;
            parm[3].Value = pager.Docount;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_FavouriteBookByUser", parm);
            return sdr;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> GetTotalClickSort()
        {
           return dal.SelectBookByTotalClick();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> GetTotalRecdSort()
        {
           return dal.SelectBookByTotalRecd();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IList<Model.Book> GetTotalCollecSort()
        {
            return dal.SelectBookByTotalcollection();
        }

        #endregion
    }
}

