using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
namespace BLL
{

    public class FavouriteBook : IBLL.IFavouriteBook
    {

        #region IFavouriteBook Ա

        IDAL.IFavouriteBook dal = DALFactory.DataAccess.CreateFavouriteBook();
        public int AddFavouriteBook(Model.FavouriteBook favouriteBook)
        {
            return dal.InsertFavouriteBook(favouriteBook);
        }

        public int RemoveFavouriteBook(int id)
        {
            return dal.DeleteFavouriteBook(id);
        }

        public int GetFavouriteBookCount(string userName)
        {
            SqlParameter parm = new SqlParameter("@UserName", SqlDbType.NVarChar);
            parm.Value = userName;
            return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCountFavouriteBook", parm));
        }

        public int ValidateFavouriteBook(string userName, int bookId)
        {
            SqlParameter[] parm ={new SqlParameter("@UserName",SqlDbType.NVarChar),
                                  new SqlParameter("@BookId",SqlDbType.Int)};
            parm[0].Value = userName;
            parm[1].Value = bookId;
            return Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_ValidateFavouriteBook", parm));
        }
    }
}

#endregion

