﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Configuration;

namespace BLLFactory
{
    public class BusinessLogic
    {
        //通过获取配置文件中信息得到BLL层路径
        private static readonly string path = ConfigurationManager.AppSettings["WebBLL"].ToString();
        //利用反射动态创建接口实例
        public static IBLL.IRedCategory CreateRedCategory()
        {
            string className = path + ".RedCategory"; 
            return (IBLL.IRedCategory)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IComments CreateComments()
        {
            string className = path + ".Comments";
            return (IBLL.IComments)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IMemberGroup CreateMemberGroup()
        {
            string className = path + ".MemberGroup";
            return (IBLL.IMemberGroup)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IFavouriteBook CreateFavouriteBook()
        {
            string className = path + ".FavouriteBook";
            return (IBLL.IFavouriteBook)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IBook CreateBook()
        {
            string className = path + ".Book";
            return (IBLL.IBook)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IRecdBook CreateRecdBook()
        {
            string className = path + ".RecdBook";
            return (IBLL.IRecdBook)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.ISections CreateSections()
        {
            string className = path + ".Sections";
            return (IBLL.ISections)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IVolume CreateVolume()
        {
            string className = path + ".Volume";
            return (IBLL.IVolume)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.ISystemInfo CreateSystemInfo()
        {
            string className = path + ".SystemInfo";
            return (IBLL.ISystemInfo)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IView CreateView()
        {
            string className = path + ".View";
            return (IBLL.IView)Assembly.Load(path).CreateInstance(className);
        }
        public static IBLL.IAuthority CreateAuthority()
        {
            string className = path + ".Authority";
            return (IBLL.IAuthority)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 利用反射动态创建分类管理接口
        /// </summary>
        /// <returns></returns>
        public static IBLL.ICategoryManager CreateCategoryManager()
        {
            string className = path + ".CategoryManager";
            return (IBLL.ICategoryManager)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 利用反射动态创建智能采集接口
        /// </summary>
        /// <returns></returns>
        public static IBLL.IAptitudecolleCtionCyclostyle CreateAptitudecolleCtionCyclostyle()
        {
            string className = path + ".AptitudecolleCtionCyclostyle";
            return (IBLL.IAptitudecolleCtionCyclostyle)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 利用反射动态创建书籍模板接口
        /// </summary>
        /// <returns></returns>
        public static IBLL.ICollectionBookCyclostyle CreateCollectionBookCyclostyle()
        {
            string className = path + ".CollectionBookCyclostyle";
            return (IBLL.ICollectionBookCyclostyle)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 利用反射动态创建普通采集接口
        /// </summary>
        /// <returns></returns>
        public static IBLL.ICollectionCyclostyle CreateCollectionCyclostyle()
        {
            string className = path + ".CollectionCyclostyle";
            return (IBLL.ICollectionCyclostyle)Assembly.Load(path).CreateInstance(className);
        }
        /// <summary>
        /// 利用反射动态创建采集内容接口
        /// </summary>
        /// <returns></returns>
        public static IBLL.INewsCollection CreateNewsCollection()
        {
            string className = path + ".NewsCollection";
            return (IBLL.INewsCollection)Assembly.Load(path).CreateInstance(className);
        }
    }
}
