using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
using Model;

namespace DAL
{
    public class CategoryManager:IDAL.ICategoryManager
    {
        #region ICategoryManager Ա

        /// <summary>
        /// ѯϢ
        /// </summary>
        /// <returns><Model.CategoyrManger></returns>
        public IList<Model.CategoryManager> SelectAllCategory()
        {
            //CategoryManager
            Model.CategoryManager modelCategoeyManager = null;
            //IList<CategoryManger>
            IList<Model.CategoryManager> categoryManagerList = new List<Model.CategoryManager>();
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAllCategory");
            while (sdr.Read())
            {
                //ʼ췽
                modelCategoeyManager = new Model.CategoryManager(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2), sdr.GetBoolean(3));
                //Ͷӵͼ
                categoryManagerList.Add(modelCategoeyManager);
            }
            //IList<CategoryManager>
            return categoryManagerList;
        }

        /// <summary>
        /// ͨϼĿ¼idѯϢ
        /// </summary>
        /// <param name="superiorId">ϼĿ¼id</param>
        /// <param name="pager">ִзҳ</param>
        /// <returns><Model.CategoryMnager></returns>
        public IList<Model.CategoryManager> SelectCategoryBySuperiorId(int superiorId, PagerParameter pager)
        {
            //CategoryManager
            Model.CategoryManager modelCategoryManager = null;
            //IList<Model.CategoryManager>
            IList<Model.CategoryManager> categoryMangerList = new List<Model.CategoryManager>();
            //
            SqlParameter[] parm ={  new SqlParameter("@SuperiorId",SqlDbType.Int),
                                    new SqlParameter("@startIndex",SqlDbType.Int),
                                    new SqlParameter("@endIndex",SqlDbType.Int),
                                    new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = superiorId;
            parm[1].Value = pager.StartIndex;
            parm[2].Value = pager.EndIndex;
            parm[3].Value = pager.Docount;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                        CommandType.StoredProcedure,
                                                        "Tengfei_SelectCategoryBySuperiorId", parm);

            while (sdr.Read())
            {
                //ʼ췽
                modelCategoryManager = new Model.CategoryManager(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3), sdr.GetBoolean(4));
                //Ͷӵͼ
                categoryMangerList.Add(modelCategoryManager);
            }
            //IList<categoryManager>
            return categoryMangerList;
        }

        /// <summary>
        /// ͨidѯϢ
        /// </summary>
        /// <param name="categoryId">id</param>
        /// <returns>IList<Model.CategoryManager></returns>
        public IList<Model.CategoryManager> SelectCategoryList(int categoryId)
        {
            //
            SqlParameter parm = new SqlParameter("@CategoryManagerId",DbType.Int32);
            //ֵ
            parm.Value = categoryId;
            //CategoryManger
            Model.CategoryManager modelCategoryManager = null;
            //IList<Model.CategoryManger>
            IList<Model.CategoryManager> categoryMangerList = new List<Model.CategoryManager>();
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryById",parm);

            while (sdr.Read())
            {
                //ʼ췽
                modelCategoryManager = new Model.CategoryManager(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2), sdr.GetBoolean(3));
                categoryMangerList.Add(modelCategoryManager);
            }
            //IList<RecdCategory>
            return categoryMangerList;
        }

        /// <summary>
        /// ӷϢ
        /// </summary>
        /// <param name="categoryManager"></param>
        /// <returns></returns>
        public int InsertCategory(Model.CategoryManager categoryManager)
        {
            //
            SqlParameter[] parm = { new SqlParameter("@ReturnId",SqlDbType.Int),
                                    new SqlParameter("@SuperiorId",SqlDbType.Int),
                                    new SqlParameter("@CategoryName",SqlDbType.NVarChar),
                                    new SqlParameter("@IsOpen",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Direction = ParameterDirection.Output;
            parm[1].Value = categoryManager.SuperiorId;
            parm[2].Value = categoryManager.CategoryName;
            parm[3].Value = categoryManager.IsOpen;
            //SqlHelper෽ִݿ
            SqlCommand cmd = SqlHelper.sqlCommand(CommandType.StoredProcedure, "Tengfei_InsertCategory", parm);
            cmd.ExecuteNonQuery();
            return Convert.ToInt32(cmd.Parameters["@ReturnId"].Value);
        }
        
        /// <summary>
        /// ޸ķϢ
        /// </summary>
        /// <param name="categoryManager"></param>
        /// <returns></returns>
        public int UpdateCategory(Model.CategoryManager categoryManager)
        {
            //
            SqlParameter[] parm ={  new SqlParameter("@CategoryManagerId",SqlDbType.Int),
                                    new SqlParameter("@SuperiorId",SqlDbType.Int),
                                    new SqlParameter("@CategoryName",SqlDbType.NVarChar),
                                    new SqlParameter("@IsOpen",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = categoryManager.CategoryId;
            parm[1].Value = categoryManager.SuperiorId;
            parm[2].Value = categoryManager.CategoryName;
            parm[3].Value = categoryManager.IsOpen;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_UpdateCategory", parm);
        }

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="categoryId"></param>
        /// <returns></returns>
        public int DeleteCategory(int categoryId)
        {
            //
            SqlParameter pram = new SqlParameter("@CategoryManagerId", SqlDbType.Int);
            //鸳ֵ
            pram.Value = categoryId;

            //SqlHelper෽ִݿ
            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteCategory", pram);
        }

        public Model.CategoryManager SelectCategory(int categoryId)
        {
            //CategoryManager
            Model.CategoryManager modelCategoeyManager = null;
            SqlParameter parm = new SqlParameter("@CategoryManagerId", SqlDbType.Int);
            parm.Value = categoryId;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCategoryManager", parm);
            while (sdr.Read())
            {
                //ʼ췽
                modelCategoeyManager = new Model.CategoryManager(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetString(2), sdr.GetBoolean(3));
            }
            //CategoryManager
            return modelCategoeyManager;
        }

        #endregion
    }
}
