using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
using Model;

namespace DAL
{
    public class Comments:IDAL.IComments
    {
        #region IComments Ա
        public IList<Model.Comments> SelectComments(PagerParameter pager)
        {
            IList<Model.Comments> commentsList = new List<Model.Comments>();
            Model.Comments comments = null;
            SqlParameter[] parm={ new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            parm[0].Value=pager.StartIndex;
            parm[1].Value=pager.EndIndex;
            parm[2].Value=pager.Docount;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAllComments", parm);
            while (sdr.Read())
            {
                comments = new Model.Comments(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5), sdr.GetBoolean(6), sdr.GetDateTime(7), sdr.GetBoolean(8), sdr.GetBoolean(9));
                commentsList.Add(comments);
            }
            return commentsList;
        }
        public int SelectCommentsCountByBookId(int BookId)
        {
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = BookId;
            string str = SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCommentsCountByBookId", parm).ToString();
            return Convert.ToInt32(str);
        }

        public IList<Model.Comments> SelectCommentsByBookId(int bookId, PagerParameter pager)
        {
            IList<Model.Comments> commentsList = new List<Model.Comments>();
            Model.Comments comments = null;
            SqlParameter[] parm ={  new SqlParameter("@BookId",SqlDbType.Int),
                                    new SqlParameter("@startIndex",SqlDbType.Int),
                                    new SqlParameter("@endIndex",SqlDbType.Int),
                                    new SqlParameter("@docount",SqlDbType.Bit)};
            parm[0].Value = bookId;
            parm[1].Value = pager.StartIndex;
            parm[2].Value = pager.EndIndex;
            parm[3].Value = pager.Docount;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCommentsByBookId", parm);
            while (sdr.Read())
            {
                comments = new Model.Comments(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetString(3), sdr.GetString(4), sdr.GetString(5), sdr.GetBoolean(6), sdr.GetDateTime(7), sdr.GetBoolean(8), sdr.GetBoolean(9));
                commentsList.Add(comments);
            }
            return commentsList;
        }

        public int InsertComments(Model.Comments comments)
        {
            SqlParameter[] parm ={  new SqlParameter("@BookId",SqlDbType.Int),
                                    new SqlParameter("@CommentTitle",SqlDbType.NVarChar),
                                    new SqlParameter("@PostUser",SqlDbType.NVarChar),
                                    new SqlParameter("@Content",SqlDbType.NText),
                                    new SqlParameter("@IsAudit",SqlDbType.Bit),
                                    new SqlParameter("@PostTime",SqlDbType.DateTime),
                                    new SqlParameter("@IsHighlights",SqlDbType.Bit),
                                    new SqlParameter("@IsTop",SqlDbType.Bit)};
            parm[0].Value = comments.BookId;
            parm[1].Value = comments.CommentTitle;
            parm[2].Value = comments.PostUser;
            parm[3].Value = comments.Content;
            parm[4].Value = comments.IsAudit;
            parm[5].Value = comments.PostTime;
            parm[6].Value = comments.IsHighlights;
            parm[7].Value = comments.IsTop;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_InsertComments", parm);
        }

        public int UpdateComments(Model.Comments comments)
        {
            SqlParameter[] parm ={  new SqlParameter("@CommentsId",SqlDbType.Int),
                                    new SqlParameter("@BookId",SqlDbType.Int),
                                    new SqlParameter("@CommentTitle",SqlDbType.NVarChar),
                                    new SqlParameter("@PostUser",SqlDbType.NVarChar),
                                    new SqlParameter("@Content",SqlDbType.NText),
                                    new SqlParameter("@IsAudit",SqlDbType.Bit),
                                    new SqlParameter("@PostTime",SqlDbType.DateTime),
                                    new SqlParameter("@IsHighlights",SqlDbType.Bit),
                                    new SqlParameter("@IsTop",SqlDbType.Bit)};
            parm[0].Value = comments.CommentsId;
            parm[1].Value = comments.BookId;
            parm[2].Value = comments.CommentTitle;
            parm[3].Value = comments.PostUser;
            parm[4].Value = comments.Content;
            parm[5].Value = comments.IsAudit;
            parm[6].Value = comments.PostTime;
            parm[7].Value = comments.IsHighlights;
            parm[8].Value = comments.IsTop;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_UpdateCommentsById", parm);
        }

        public int DeleteComments(int commentsId)
        {
            SqlParameter pram =new SqlParameter("@CommentsId",SqlDbType.Int);
            pram.Value = commentsId;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteComments", pram);
        }

        #endregion
    }
}
