using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;
using Model;

namespace DAL
{
    public class MemberGroup:IDAL.IMemberGroup
    {
        #region IMemberGroup Ա

        /// <summary>
        /// ͨҳѯݲзҳ
        /// </summary>
        /// <param name="pager">PagerParameter</param>
        /// <returns>IList</returns>
        public IList<Model.MemberGroup> SelectMemberGroup(PagerParameter pager)
        {
            //MemberGroup
            Model.MemberGroup memberGroup = null;
            //IList<MemberGroup>
            IList<Model.MemberGroup> memberGroupList = new List<Model.MemberGroup>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectMemberGroup", parm);
            while (sdr.Read())
            {
                //ʼ췽
                memberGroup = new Model.MemberGroup(sdr.GetInt32(1), sdr.GetString(2), sdr.GetInt32(3), sdr.GetInt32(4), sdr.GetInt32(5), sdr.GetInt32(6),sdr.GetInt32(7));
                //Ͷӵͼ
                memberGroupList.Add(memberGroup);
            }
            //IList<RecdCategory>
            return memberGroupList;
        }
        /// <summary>
        /// ѯлԱϢͨRating
        /// </summary>
        /// <returns></returns>
        public IList<Model.MemberGroup> SelectAllMemberGroup()
        {
            //MemberGroup
            Model.MemberGroup memberGroup = null;
            //IList<MemberGroup>
            IList<Model.MemberGroup> memberGroupList = new List<Model.MemberGroup>();
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllMemberGroup");
            while (sdr.Read())
            {
                //ʼ췽
                memberGroup = new Model.MemberGroup(sdr.GetInt32(0), sdr.GetString(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetInt32(4), sdr.GetInt32(5), sdr.GetInt32(6));
                //Ͷӵͼ
                memberGroupList.Add(memberGroup);
            }
            //IList<RecdCategory>
            return memberGroupList;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="memberGroupId"></param>
        /// <returns></returns>
        public Model.MemberGroup SelectNextMemberGroupById(int memberGroupId)
        {
            //MemberGroup
            Model.MemberGroup memberGroup = null;
            SqlParameter parm = new SqlParameter("@MemberGroupId", SqlDbType.Int);
            parm.Value = memberGroupId;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                     CommandType.StoredProcedure,
                                                     "Tengfei_SelectNextMemberGroup", parm);
            while (sdr.Read())
            {
                //ʼ췽
                memberGroup = new Model.MemberGroup(sdr.GetInt32(0), sdr.GetString(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetInt32(4), sdr.GetInt32(5), sdr.GetInt32(6));
            }
            //IList<RecdCategory>
            return memberGroup;
        }
        /// <summary>
        /// ͨmemberGroupIdѯϢ
        /// </summary>
        /// <param name="memberGroupId">ʶId</param>
        /// <returns>MemberGroupͶ</returns>
        public Model.MemberGroup SelectMemberGroupById(int memberGroupId)
        {
            Model.MemberGroup memberGroup = null;
            SqlParameter parm = new SqlParameter("@MemberGroupId",SqlDbType.Int);
            parm.Value = memberGroupId;
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString, CommandType.StoredProcedure,
                                                        "Tengfei_SelectMemberGroupById", parm);
            while (sdr.Read())
            {
                memberGroup = new Model.MemberGroup(sdr.GetInt32(0), sdr.GetString(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetInt32(4), sdr.GetInt32(5),sdr.GetInt32(6));
            }
            return memberGroup;
        }
        /// <summary>
        /// ͨMemberGroupͶ
        /// лȡ洢ִв
        /// </summary>
        /// <param name="MemberGroup">MemberGroupͶ</param>
        /// <returns>ִӰ</returns>
        public int InsertMemberGroup(Model.MemberGroup memberGroup)
        {
            SqlParameter[] parm ={new SqlParameter("@ReturnId",SqlDbType.Int),
                                  new SqlParameter("@MemberGroupName",SqlDbType.NVarChar),
                                  new SqlParameter("@DayRecTicket",SqlDbType.Int),
                                  new SqlParameter("@DayAdTicket",SqlDbType.Int),
                                  new SqlParameter("@LibraryCount",SqlDbType.Int),
                                  new SqlParameter("@PromoteScore",SqlDbType.Int),
                                  new SqlParameter("@Rating",SqlDbType.Int)};
            parm[0].Direction = ParameterDirection.Output;
            parm[1].Value = memberGroup.MemberGroupName;
            parm[2].Value = memberGroup.DayRecTicket;
            parm[3].Value = memberGroup.DayAdTicket;
            parm[4].Value = memberGroup.LibraryCount;
            parm[5].Value = memberGroup.PromoteScore;
            parm[6].Value = memberGroup.Rating;

            SqlCommand cmd = SqlHelper.sqlCommand(CommandType.StoredProcedure, "Tengfei_InsertMemberGroup", parm);
            cmd.ExecuteNonQuery();
            return (int)cmd.Parameters["@ReturnId"].Value;
        }

        /// <summary>
        ///ͨMemberGroupͶ
        /// лȡ洢ִи²
        /// </summary>
        /// <param name="MemberGroup">MemberGroupͶ</param>
        /// <returns>ִӰ</returns>
        public int UpdateMemberGroup(Model.MemberGroup memberGroup)
        {
            SqlParameter[] parm ={new SqlParameter("@MemberGroupId",SqlDbType.Int),
                                  new SqlParameter("@MemberGroupName",SqlDbType.NVarChar),
                                  new SqlParameter("@DayRecTicket",SqlDbType.Int),
                                  new SqlParameter("@DayAdTicket",SqlDbType.Int),
                                  new SqlParameter("@LibraryCount",SqlDbType.Int),
                                  new SqlParameter("@PromoteScore",SqlDbType.Int),
                                  new SqlParameter("@Rating",SqlDbType.Int)};
            parm[0].Value = memberGroup.MemberGroupId;
            parm[1].Value = memberGroup.MemberGroupName;
            parm[2].Value = memberGroup.DayRecTicket;
            parm[3].Value = memberGroup.DayAdTicket;
            parm[4].Value = memberGroup.LibraryCount;
            parm[5].Value = memberGroup.PromoteScore;
            parm[6].Value = memberGroup.Rating;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_UpdateMemberGroup", parm);
        }

        /// <summary>
        /// ͨMemberGroupIDɾ
        /// </summary>
        /// <param name="MemberGroup">ƼId</param>
        /// <returns>ִӰ</returns>
        public int DeleteMemberGroup(int memberGroupId)
        {
            SqlParameter parm = new SqlParameter("@MemberGroupId", SqlDbType.Int);
            parm.Value = memberGroupId;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteMemberGroup", parm);
        }
       
        #endregion
    }
}
