using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using DBUtility;

namespace DAL
{
    public class RecdBook:IDAL.IRecdBook
    {
        #region IRecdBook Ա


        /// <summary>
        /// ѯƼ鼮Ϣ
        /// </summary>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.RecdBook></returns>
        public IList<Model.RecdBook> SelectRecdBook(Model.PagerParameter pager)
        {
            //RecdBook
            Model.RecdBook recdBook = null;
            //IList<RecdBook>
            IList<Model.RecdBook> recdBookList = new List<Model.RecdBook>();
            //
            SqlParameter[] parm ={new SqlParameter("@startIndex",SqlDbType.Int),
                                  new SqlParameter("@endIndex",SqlDbType.Int),
                                  new SqlParameter("@docount",SqlDbType.Bit)};
            //鸳ֵ
            parm[0].Value = pager.StartIndex;
            parm[1].Value = pager.EndIndex;
            parm[2].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectAllRecdBook", parm);
            while (sdr.Read())
            {
                //ʼ췽
                recdBook = new Model.RecdBook(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetInt32(4),sdr.GetString(5));
                //Ͷӵͼ
                recdBookList.Add(recdBook);
            }
            //IList<Book>
            return recdBookList;
        }

        /// <summary>
        ///ͨƼIdѯƼ鼮 
        /// </summary>
        /// <param name="recdCategoryId">ƼбID</param>
        /// <param name="pager">PagerParameter,ִзҳ</param>
        /// <returns>IList<Model.RecdBook></returns>
        public IList<Model.RecdBook> SelectRecdBookById(int recdCategoryId, Model.PagerParameter pager)
        {
            //RecdBook
            Model.RecdBook recdBook = null;
            //IList<RecdBook>
            IList<Model.RecdBook> recdBookList = new List<Model.RecdBook>();
            //
            SqlParameter[] parm ={  new SqlParameter("@RecdCategoryId",SqlDbType.Int),
                                    new SqlParameter("@startIndex",SqlDbType.Int),
                                    new SqlParameter("@endIndex",SqlDbType.Int),
                                    new SqlParameter("@docount",SqlDbType.Bit)
                                  };
            //鸳ֵ
            parm[0].Value = recdCategoryId;
            parm[1].Value = pager.StartIndex;
            parm[2].Value = pager.EndIndex;
            parm[3].Value = pager.Docount;
            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectRecdBookById", parm);
            while (sdr.Read())
            {
                //ʼ췽
                recdBook = new Model.RecdBook(sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetInt32(4), sdr.GetString(5));
                //Ͷӵͼ
                recdBookList.Add(recdBook);
            }
            //IList<Book>
            return recdBookList;
        }

        /// <summary>
        /// ͨ鼮ŲѯƼ鼮Ϣ
        /// </summary>
        /// <param name="BookId">鼮ID</param>
        /// <returns>Model.RecdBookƼ鼮</returns>
        public Model.RecdBook SelectRecdBookByBookId(int BookId)
        {
            //RecdBook
            Model.RecdBook recdBook = null;

            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);

            parm.Value = BookId;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectRecdBookByBookId", parm);
            while (sdr.Read())
            {

                //ʼ췽
                recdBook = new Model.RecdBook(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetString(4));
            }
            return recdBook;
        }

        /// <summary>
        /// Ƽ鼮
        /// </summary>
        /// <param name="recdBook">Model.RecdBook,Ƽ鼮Ϣ</param>
        /// <returns>ز鼮</returns>
        public int InsertRecdBook(Model.RecdBook recdBook)
        {
            SqlParameter[] parm ={ new SqlParameter("@RecdCategoryId",SqlDbType.Int),
                                   new SqlParameter("@BookId",SqlDbType.Int),
                                   new SqlParameter("@Sort",SqlDbType.Int),
                                    new SqlParameter("@RecdCategoryName",SqlDbType.NVarChar)
                                   };

            //SqlParameterĲ
            parm[0].Value = recdBook.RecdCategoryId;
            parm[1].Value = recdBook.BookId;
            parm[2].Value = recdBook.Sort;
            parm[3].Value = recdBook.RecdCategoryName;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_InsertRecdBook", parm);
        }
        /// <summary>
        /// 鼮Ϣ
        /// </summary>
        /// <param name="recdBook">Model.RecdBook,Ҫ鼮Ϣ</param>
        /// <returns>ظ鼮</returns>
        public int UpdateRecdBook(Model.RecdBook recdBook)
        {
            SqlParameter[] parm ={  new SqlParameter("@RecdBookId",SqlDbType.Int),
                                    new SqlParameter("@RecdCategoryId",SqlDbType.Int),
                                    new SqlParameter("@BookId",SqlDbType.Int),
                                    new SqlParameter("@Sort",SqlDbType.Int),
                                    new SqlParameter("@RecdCategoryName",SqlDbType.NVarChar)};

            //SqlParameterĲ
            parm[0].Value = recdBook.RecdBookId;
            parm[1].Value = recdBook.RecdCategoryId;
            parm[2].Value = recdBook.BookId;
            parm[3].Value = recdBook.Sort;
            parm[4].Value = recdBook.RecdCategoryName;


            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_UpdateRecdBook", parm);
        }

        /// <summary>
        /// ɾ鼮Ϣ
        /// </summary>
        /// <param name="recdBookId">Ƽ鼮</param>
        /// <returns>ɾƼ鼮</returns>
        public int DeleteRecdBook(int recdBookId)
        {
            SqlParameter parm = new SqlParameter("@RecdBookId", SqlDbType.Int);

            parm.Value = recdBookId;

            return SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure,
                                             "Tengfei_DeleteRecdBook", parm);
        }

        /// <summary>
        /// Ƽ鼮ŲѯƼ鼮
        /// </summary>
        /// <param name="RecdBookId">Ƽ鼮</param>
        /// <returns>Model.RecdBookƼ鼮</returns>
        public Model.RecdBook SelectRecdBookByRecdBookId(int RecdBookId)
        {
            //RecdBook
            Model.RecdBook recdBook = null;
            //
            SqlParameter parm = new SqlParameter("@RecdBookId", SqlDbType.Int);

            //鸳ֵ
            parm.Value = RecdBookId;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectRecdBookByRecdBookId", parm);
            while (sdr.Read())
            {
                //ʼ췽
                recdBook = new Model.RecdBook(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetString(4));
            }
            //IList<Book>
            return recdBook;
        }


        /// <summary>
        /// 2008-5-20
        /// </summary>
        /// <param name="recordCount"></param>
        /// <param name="recdCategory"></param>
        /// <returns></returns>
        public IList<Model.RecdBook> SelectRecdBookByRecdCategory(int recordCount, string recdCategory)
        {
            //RecdBook
            Model.RecdBook recdBook = null;
            //IList<RecdBook>
            IList<Model.RecdBook> recdBookList = new List<Model.RecdBook>();
            //
            SqlParameter[] parm ={ new SqlParameter("@RecordCount", SqlDbType.Int),
                                 new SqlParameter("@RecdCategory",SqlDbType.NVarChar)};

            //鸳ֵ
            parm[0].Value =recordCount;
            parm[1].Value = recdCategory;

            //SqlHelper෽ִݿ
            SqlDataReader sdr = SqlHelper.ExecuteReader(SqlHelper.connectionString,
                                                      CommandType.StoredProcedure,
                                                      "Tengfei_SelectRecdBook", parm);
            while (sdr.Read())
            {
                //ʼ췽
                recdBook = new Model.RecdBook(sdr.GetInt32(0), sdr.GetInt32(1), sdr.GetInt32(2), sdr.GetInt32(3), sdr.GetString(4));
                recdBookList.Add(recdBook);
            }
            //IList<Book>
            return recdBookList;
        }
        #endregion
    }
}
