﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Configuration;
using IDAL;
namespace DALFactory
{
    public class DataAccess
    {
        //通过获取配置文件中DAL层所在路径
        private static readonly string path = ConfigurationManager.AppSettings["WebDAL"].ToString();

        //通过反射动态创建接口实例
        public static IRedCategory CreateRedCategory()
        {
            string className = path + ".RedCategory";
            return (IRedCategory)Assembly.Load(path).CreateInstance(className);
        }

        public static IMemberGroup CreateMemberGroup()
        {
            string className = path + ".MemberGroup";
            return (IMemberGroup)Assembly.Load(path).CreateInstance(className);
        }

        public static IFavouriteBook CreateFavouriteBook()
        {
            string className = path + ".FavouriteBook";
            return (IFavouriteBook)Assembly.Load(path).CreateInstance(className);
        }

        public static IComments CreateComments()
        {
            string className = path + ".Comments";
            return (IComments)Assembly.Load(path).CreateInstance(className);
        }
        public static IDAL.IBook CreateBook()
        {
            string className = path + ".Book";
            return (IDAL.IBook)Assembly.Load(path).CreateInstance(className);
        }
        public static IDAL.IRecdBook CreateRecdBook()
        {
            string className = path + ".RecdBook";
            return (IDAL.IRecdBook)Assembly.Load(path).CreateInstance(className);
        }
        public static IDAL.ISections CreateSections()
        {
            string className = path + ".Sections";
            return (IDAL.ISections)Assembly.Load(path).CreateInstance(className);
        }
        public static IDAL.IVolume CreateVolume()
        {
            string className = path + ".Volume";
            return (IDAL.IVolume)Assembly.Load(path).CreateInstance(className);
        }
        public static ISystemInfo CreateSystemInfo()
        {
            string className = path + ".SystemInfo";
            return (ISystemInfo)Assembly.Load(path).CreateInstance(className);
        }
        public static IView CreateView()
        {
            string className = path + ".View";
            return (IView)Assembly.Load(path).CreateInstance(className);
        }
        public static IAuthority CreateAuthority()
        {
            string className = path + ".Authority";
            return (IAuthority)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 通过反射动态创建分类管理接口
        /// </summary>
        /// <returns></returns>
        public static ICategoryManager CreateCategroyManager()
        {
            string className = path + ".CategoryManager";
            return (ICategoryManager)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 通过反射动态创建智能采集接口
        /// </summary>
        /// <returns></returns>
        public static IAptitudecolleCtionCyclostyle CreateAptitudecolleCtionCyclostyle()
        {
            string className = path + ".AptitudecolleCtionCyclostyle";
            return (IAptitudecolleCtionCyclostyle)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 通过反射动态创建书籍模板接口
        /// </summary>
        /// <returns></returns>
        public static ICollectionBookCyclostyle CreateCollectionBookCyclostyle()
        {
            string className = path + ".CollectionBookCyclostyle";
            return (ICollectionBookCyclostyle)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 通过反射动态创建普通采集接口
        /// </summary>
        /// <returns></returns>
        public static ICollectionCyclostyle CreateCollectionCyclostyle()
        {
            string className = path + ".CollectionCyclostyle";
            return (ICollectionCyclostyle)Assembly.Load(path).CreateInstance(className);
        }

        /// <summary>
        /// 通过反射动态创建采集内容接口
        /// </summary>
        /// <returns></returns>
        public static INewsCollection CreateNewsCollection()
        {
            string className = path + ".NewsCollection";
            return (INewsCollection)Assembly.Load(path).CreateInstance(className);
        }
    }
}
