﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Clientele_IndexPage : System.Web.UI.MasterPage
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        //if (common.GetWebSiteStatus() == 0)
        //{
        //    Response.Redirect("WebSiteClose.aspx");
        //}
        if (!IsPostBack)
        {
            MessageBind();
        }
        labTime.Text = "当前时间为：" + System.DateTime.Now.ToString();
        if (Session["UserName"] != null)
        {
            Panel2.Visible = true;
            Panel1.Visible = false;
            LoginMessage.Text = "欢迎回来：" + Session["UserName"].ToString();
        }
    }
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        
        bool validate = Membership.ValidateUser(UserName.Text, Password.Text);
        if (validate == true)
        {
            ProfileCommon p = Profile.GetProfile(UserName.Text);
            if (p.IsLoked == false)
            {
                Session["UserName"] = UserName.Text;
                string role = common.GetAuthorityName(p.Rating);
                if (role == "系统管理员")
                {
                    p.LoginCount += 1;
                    p.Score += common.GetLoginScore();
                    p.Save();
                    Response.Redirect("/TengfeiWeb/Admin/Admin.htm");
                }
                else
                {
                    Panel2.Visible = true;
                    Panel1.Visible = false;
                    LoginMessage.Text = "欢迎回来：" + Session["UserName"].ToString();
                    p.LoginCount += 1;
                    p.Score += common.GetLoginScore();
                    p.Save();
                }
            }
            else
            {
                Response.Write("<script>alert('用户帐号已被锁定，请联系管理员解锁。');</script>");
                Server.Transfer("Login.aspx");
            }
        }
        else
        {
            Response.Write("<script>alert('用户名或者密码错误。');</script>");
            Server.Transfer("Login.aspx");
        }
    }
    public void MessageBind()
    {
        IList<Model.Book> bookSource = book.GetTopBookList(4);
        string text = "";
        if (bookSource != null)
        {
            foreach (Model.Book b in bookSource)
            {
                Model.Book bk = b;
                string bookName = bk.BookName;
                int bookId = bk.BookId;
                string author = bk.Author;
                text += "<tr><td style='text-align:left;'><a href='BookInfo.aspx?bookId=" + bookId + "'>" + bookName + "</a></td><td style='text-align:left'>作者:" + author + "</td></tr>";
            }
        }
        PopupWin1.Title = "<div style='text-align:left'>系统消息！<font color=red>(最新书籍)</font></div>";
        PopupWin1.Message = "<table>"+text+"</table>";
    }
    protected void lkbLoginOut_Click(object sender, EventArgs e)
    {
        Session["UserName"] = null;
        Server.Transfer("Index.aspx");
    }
}

