﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Data.SqlClient;


public partial class Controls_AddBook : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    IBLL.ISystemInfo systeminfo = BLLFactory.BusinessLogic.CreateSystemInfo();

    /// <summary>
    /// 创建Model层Book书籍对象
    /// </summary>
    Model.Book modelbook = new Model.Book();
    Model.SystemInfo modelsysteminfo = new Model.SystemInfo();

    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        //判断Session["UserName"]是否为空，如果为空则跳转到登陆页面
        if (Session["UserName"] != null)
        {
            if (!IsPostBack)
            {

                ViewState["UserName"] = Session["UserName"].ToString();
                ViewState["PhotoPath"] = ConfigurationManager.AppSettings["PhotoPath"].ToString();
                DataBindCategory();

            }
        }
        else
        {
            Response.Redirect("~/Clientele/Login.aspx");
        }
    }

    /// <summary>
    /// 点击保存按钮事件
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //判断用户是否选择了类别
        if (ddlBigCategoryName.SelectedIndex != ddlBigCategoryName.Items.Count - 1 && ddlSmallCategoryName.SelectedIndex != ddlSmallCategoryName.Items.Count - 1)
        {
            if (ViewState["UserName"] != null)
            {
                ProfileCommon PC = Profile.GetProfile(ViewState["UserName"].ToString());
                modelbook.BookName = txtBookTitle.Text;
                modelbook.Author = PC.PenName;
                //获得当前用户名对象
                modelbook.UserName = ViewState["UserName"].ToString();

                //如果用户未指定书籍图片，则使用默认图片作为书籍的封面
                if (this.txtImageURL.Value == "")
                {
                    //从配置文件中获取书籍封面保存地址
                    string PhotoPath = ViewState["PhotoPath"].ToString();

                    //默认图片
                    modelbook.Images = PhotoPath + "book.jpg";
                }
                else
                {
                    modelbook.Images = this.txtImageURL.Value;

                }
                modelbook.Protagonists = txtProtagonists.Text.ToString();
                modelbook.BigCategoryID = Convert.ToInt32(ddlBigCategoryName.SelectedValue);
                modelbook.SmallCategoryID = Convert.ToInt32(ddlSmallCategoryName.SelectedValue);

                //如果自动审核状态为允许（AutoAudit值为1），则让书籍的审核状态为通过，否则为未通过
                if (ViewState["AutoAudit"].ToString() == "1")
                {
                    modelbook.StateAudit = Convert.ToInt32(ViewState["AutoAudit"].ToString());
                }
                else
                {
                    modelbook.StateAudit = 0;
                }
                modelbook.Process = ddlProcess.SelectedItem.Text.ToString();
                modelbook.Nature = ddlNature.SelectedItem.Text.ToString();
                modelbook.Authorized = ddlAuthorized.SelectedItem.Text.ToString();
                modelbook.FirstIssue = Convert.ToInt32(ddlFirstIssue.SelectedValue);
                modelbook.TotalClick = Convert.ToInt32(txtTotalClick.Text);
                modelbook.MonthClick = Convert.ToInt32(txtMonthClick.Text);
                modelbook.WeekClick = Convert.ToInt32(txtWeekClick.Text);
                modelbook.DayClick = Convert.ToInt32(txtDayClick.Text);
                modelbook.CollectionNum = Convert.ToInt32(txtCollectionNum.Text);
                modelbook.RecommendedNum = Convert.ToInt32(txtRecommendedNum.Text);
                modelbook.AddTime = DateTime.Now;
                modelbook.BookIntroduction = ftbBookIntroduction.Text.ToString();

                //调用业务逻辑层方法执行添加书籍信息操作，返回新增书籍行数
                int i = book.AddBook(modelbook);
                if (i == 0)
                {
                    Response.Write("<script>alert('添加书籍失败！');</script>");
                }
                else
                {
                    //添加书籍成功后清除页面数据
                    Response.Write("<script>alert('添加书籍成功！');</script>");
                    txtImageURL.Value = "";
                    txtAuthor.Text = "";
                    ftbBookIntroduction.Text = "";
                    txtBookTitle.Text = "";
                    txtProtagonists.Text = "";
                    ddlAuthorized.SelectedIndex = 0;
                    ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
                    ddlFirstIssue.SelectedIndex = 0;
                    ddlNature.SelectedIndex = 0;
                    ddlProcess.SelectedIndex = 0;
                    ddlSmallCategoryName.Items.Clear();
                    ddlSmallCategoryName.Items.Add("请选择左边大类");
                    ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
                    ddlCategoryManager.SelectedIndex = ddlCategoryManager.Items.Count - 1;
                }
            }
            else
            {
                Response.Redirect("~/Clientele/Login.aspx");
            }
        }
        else
        {
            Response.Write("<script>alert('请选择书籍分类!')</script>");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.close()</script>");
    }

    /// <summary>
    /// 从数据库读取数据，绑定页面控件
    /// </summary>
    public void DataBindCategory()
    {
        if (ViewState["UserName"] != null)
        {
            ProfileCommon PC = Profile.GetProfile(ViewState["UserName"].ToString());
            txtAuthor.Text = PC.PenName;
        }
        //判断书籍是否为自动审核
        int AutoAudit = common.GetAutomatismAuditingBook();
        if (AutoAudit == 0)
        {
            ViewState["AutoAudit"] = AutoAudit.ToString();
            lblAutoAudit.Text = "×";
            lblAutoAudit.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            ViewState["AutoAudit"] = AutoAudit.ToString();
            lblAutoAudit.Text = "√";
            lblAutoAudit.ForeColor = System.Drawing.Color.Blue;
        }
        //绑定书籍总类别到下拉列表
        SqlParameter parms = new SqlParameter("@SuperiorId", SqlDbType.Int);
        parms.Value =1;
        common.DropDownListBind(ddlCategoryManager, "CategoryName", "CategoryManagerId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectSuperiorCategoryBySuperiorId", parms);
        ddlCategoryManager.Items.Add("请选择书籍类别");
        ddlCategoryManager.SelectedIndex = ddlCategoryManager.Items.Count - 1;
        ddlBigCategoryName.Items.Add("请选择分类");
        ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
        ddlSmallCategoryName.Items.Add("请选择左边大类");
        ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;

    }

    /// <summary>
    /// 大类(下拉列表)选项发生改变时的事件
    /// </summary>
    protected void ddlBigCategoryName_SelectedIndexChanged(object sender, EventArgs e)
    {
        //如果用户选择了大类，则查询该大类下的小类信息
        if (ddlBigCategoryName.SelectedIndex != ddlBigCategoryName.Items.Count - 1)
        {
            ddlSmallCategoryName.Items.Clear();
            int BigCategoryID = Convert.ToInt32(ddlBigCategoryName.SelectedValue);
            SqlParameter parm = new SqlParameter("@SuperiorId", SqlDbType.Int);
            parm.Value = BigCategoryID;
            common.DropDownListBind(ddlSmallCategoryName, "CategoryName", "CategoryManagerId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectSuperiorCategoryBySuperiorId", parm);
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
        else 
        {
            ddlSmallCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
    }
    /// <summary>
    /// 查询书籍封面保存地址
    /// </summary>
    /// <returns>返回书籍封面保存地址的URL</returns>
    public string GetPhotoPath()
    {
        string str = ViewState["PhotoPath"].ToString();
        return str;
    }


    /// <summary>
    /// 更改书籍总类别选项后，绑定该类别下的大类信息到下拉列表
    /// </summary>
    protected void ddlCategoryManager_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (ddlCategoryManager.SelectedIndex != ddlCategoryManager.Items.Count - 1)
        {
            ddlBigCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Clear();
            //绑定数据到下拉列表
            SqlParameter parms = new SqlParameter("@SuperiorId", SqlDbType.Int);
            parms.Value = ddlCategoryManager.SelectedValue;
            common.DropDownListBind(ddlBigCategoryName, "CategoryName", "CategoryManagerId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectSuperiorCategoryBySuperiorId", parms);
            ddlBigCategoryName.Items.Add("请选择分类");
            ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
        else {
            ddlBigCategoryName.Items.Clear();
            ddlSmallCategoryName.Items.Clear();
            ddlBigCategoryName.Items.Add("请选择分类");
            ddlBigCategoryName.SelectedIndex = ddlBigCategoryName.Items.Count - 1;
            ddlSmallCategoryName.Items.Add("请选择左边大类");
            ddlSmallCategoryName.SelectedIndex = ddlSmallCategoryName.Items.Count - 1;
        }
    }
}
