﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_AddSection : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例，并创建Model层Sections章节对象
    /// </summary>
    IBLL.ISections Sections = BLLFactory.BusinessLogic.CreateSections();
    Model.Sections ModelSections = new Model.Sections();

    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        if (!IsPostBack)
        {
            //判断Session["UserName"]是否为空，如果为空则跳转到登陆页面
            if (Session["UserName"] != null)
            {
                ViewState["UserName"] = Session["UserName"].ToString();

                //这里判断该页面是从书籍列表直接进去添加章节还是从分类卷进去章节列表添加章节
                if (Request.QueryString["Id"] != null && Request.QueryString["Tag"] == "BookId")
                {
                    ViewState["BookId"] = Convert.ToInt32(Request.QueryString["Id"]);
                    GetSectionsInfo();
                }
                else if (Request.QueryString["Id"] != null && Request.QueryString["Tag"] == "VolumeId")
                {
                    ViewState["VolumeId"] = Convert.ToInt32(Request.QueryString["Id"]);
                    GetSectionsInfo();
                }
            }
            else
            {
                Response.Redirect("~/Clientele/Login.aspx");
            }

        }
    }


    /// <summary>
    /// 绑定页面相关控件
    /// </summary>
    public void GetSectionsInfo()
    {
        //查询系统设置里章节是否为自动审核
        int AutoHTML = common.GetAutomatismHTML();
        int AutoAudit = common.GetAutomatismAuditingBook();
        if (AutoAudit == 0)
        {
            ViewState["AutoAudit"] = AutoAudit.ToString();
            lblAutoAudit.Text = "×";
            lblAutoAudit.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            ViewState["AutoAudit"] = AutoAudit.ToString();
            lblAutoAudit.Text = "√";
            lblAutoAudit.ForeColor = System.Drawing.Color.Blue;
        }

        if (AutoHTML == 0)
        {
            lblAutoHtml.Text = "×";
            lblAutoHtml.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            lblAutoHtml.Text = "√";
            lblAutoHtml.ForeColor = System.Drawing.Color.Blue;
        }



        if (ViewState["BookId"] != null)
        {
            int BookId = Convert.ToInt32(ViewState["BookId"]);

            //绑定下拉列表
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = BookId;
            common.DropDownListBind(ddlCategory, "VolumeName", "VolumeId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectAllVolumeByBookId", parm);
            ddlCategory.SelectedIndex = 0;
        }
        else if (ViewState["VolumeId"]!=null)
        {
            int VolumeId = Convert.ToInt32(ViewState["VolumeId"]);
            int BookId = common.GetBookIdByVolumeId(VolumeId);

            //绑定下拉列表
            SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
            parm.Value = BookId;
            common.DropDownListBind(ddlCategory, "VolumeName", "VolumeId",
                  SqlHelper.connectionString, CommandType.StoredProcedure,
                  "Tengfei_SelectAllVolumeByBookId", parm);
             ddlCategory.SelectedValue = VolumeId.ToString();
        
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        ModelSections.VolumeId = Convert.ToInt32(ddlCategory.SelectedValue);
        ModelSections.SectionTitle = txtSectionTitle.Text.ToString();
        ModelSections.CharNum = FreeTextBox.Text.Length;
        ModelSections.Contents = FreeTextBox.Text.ToString();
        ModelSections.AddTime = DateTime.Now;
        //如果自动审核状态为允许（AutoAudit值为1），则让书籍的审核状态为通过
        if (ViewState["AutoAudit"].ToString() == "1")
        {
            ModelSections.StateAudit = Convert.ToInt32(ViewState["AutoAudit"].ToString());
        }
        else
        {
            ModelSections.StateAudit = 0;
        }
        
        //执行新增章节操作，返回新增章节的行数
        int IsOK= Sections.AddSections(ModelSections);
        if (IsOK != 0)
        {
            
            if (ViewState["UserName"] != null)
            {
                //新增章节成功，则给该用户增加5分的积分
                ProfileCommon p = Profile.GetProfile(ViewState["UserName"].ToString());
                p.Score += 5;
                p.Save();
            }
            Response.Write("<script>alert('添加章节成功!')</script>");
            Response.Write("<script>window.close()</script>");
        }
        else
        {
            Response.Write("<script>alert('添加章节失败!')</script>");
        }
    }
    protected void FreeTextBox_TextChanged(object sender, EventArgs e)
    {
        txtWordCount.Text = FreeTextBox.Text.Length.ToString();
    }
}
