﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="BookInfoList.ascx.cs" Inherits="Controls_BookInfo" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>


<script type="text/javascript" language="javascript">
    function Editonclick(bookId) {
           window.showModalDialog('EditBookInfo.aspx?BookId='+bookId,'window','dialogWidth=715px;dialogHeight=660px;status:no;help:no;');
           window.location.href = window.location.href;
    }
     function Create()
    {
        if(confirm("系统提示:\n你确实要重新生成?")) 
        { 
            window.showModalDialog('CreateXML.aspx','window','dialogWidth=415px;dialogHeight=270px;status:no;help:no;')
            window.location.href = window.location.href;
        }
    }

</script>


<style type="text/css">
<!--
a:link {
	text-decoration: none;
}
a:visited {
	text-decoration: none;
}
a:hover {
	text-decoration: none;
}
a:active {
	text-decoration: none;
}
-->
</style>

<table style="width: 100%; font-size: small;">
    <tr>
        <td style="background-color:#c3daf9;">
            <asp:GridView ID="GVBookInfoList" runat="server" AutoGenerateColumns="False" Font-Names="宋体"
                Font-Size="Small" Width="100%" OnRowDataBound="GridView1_RowDataBound" AllowSorting="True" DataKeyNames="bookId" CssClass="GridView_Style" OnDataBound="GVBookInfoList_DataBound" EmptyDataText="此栏目暂无任何内容">
                <Columns>
                    <asp:BoundField DataField="bookId" HeaderText="ID" >
                        <ItemStyle HorizontalAlign="Center" CssClass="Item_Style" />
                    </asp:BoundField>
                    <asp:BoundField DataField="bookName" HeaderText="书籍名称" >
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="大类名称">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("bigCategoryID") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# getBigCategoryName((int)Eval("bigCategoryID")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="小类名称">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("smallCategoryID") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label2" runat="server" Text='<%# getSmallCategoryName((int)Eval("smallCategoryID")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="审核">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox5" runat="server" Text='<%# Bind("stateAudit") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:Label ID="Label5" runat="server" ForeColor='<%# GetColor((int)Eval("stateAudit"))%>' Text='<%# GetText((int)Eval("stateAudit"))%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="nature" HeaderText="性质" />
                    <asp:BoundField DataField="authorized" HeaderText="授权状态" />
                    <asp:TemplateField HeaderText="操作">
                        <ItemTemplate>
                             <a id="AEdit" href="#" onclick="return Editonclick(<%#Eval("bookId")%>)">编辑</a>
                            <asp:LinkButton ID="lbtnAudit" runat="server"   OnClientClick='return confirm("系统提示:\n 你确实要通过审核?")' CommandArgument='<%#Eval("bookId")%>' OnCommand="lbtnAudit_Command">审核</asp:LinkButton>
                            <asp:LinkButton ID="lbtnD_Audit" runat="server"  OnClientClick='return confirm("系统提示:\n 你确实要撤销审核?")' CommandArgument='<%#Eval("bookId")%>' OnCommand="lbtnD_Audit_Command">撤审</asp:LinkButton>
                            <asp:LinkButton ID="lbtnCreate" runat="server"  OnClientClick='Create()'>生成</asp:LinkButton>
                            <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("bookId", "~/BookManager/VolumeInfo.aspx?BookId={0}")%>' >分类卷</asp:HyperLink>
                            <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl='<%# Eval("bookId", "~/BookManager/SectionInfo.aspx?BookId={0}")%>' >章节</asp:HyperLink>
                            <asp:HyperLink ID="HyperLink3" runat="server" NavigateUrl='<%# Eval("bookId", "~/BookManager/CommentList.aspx?BookId={0}")%>' >评论</asp:HyperLink>
                            <asp:LinkButton ID="lbtnDelete" runat="server"  OnClientClick='return confirm("系统提示:\n 你确实要删除该书籍?")' CommandArgument='<%#Eval("bookId")%>' OnCommand="lbtnDelete_Command">删除</asp:LinkButton>&nbsp;
                           
                       
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:TemplateField>
                </Columns>
                <HeaderStyle CssClass="GridViewHeaderStyle" />
            </asp:GridView>
        </td>
    </tr>
    <tr>
        <td>
            <webdiyer:AspNetPager ID="Pager" runat="server" CssClass="AspNetPager" CustomInfoTextAlign="Left" FirstPageText='<font face="webdings">9</font>'
                LastPageText='<font face="webdings">:</font>' NextPageText='<font face="webdings">4</font>'
                NumericButtonTextFormatString="[{0}]" OnPageChanging="Pager_PageChanging" PageIndexBoxStyle="border:solid 1px Blue;color:Red;text-align:center;"
                PageIndexBoxType="TextBox" PageSize="5" PrevPageText='<font face="webdings">3</font>'
                ShowCustomInfoSection="Left" ShowPageIndexBox="Always" SubmitButtonStyle="width:35px;border:solid 1px Blue;color:Red;background-color:yellow"
                SubmitButtonText="Go" TextAfterPageIndexBox="页" TextBeforePageIndexBox="转到第" CustomInfoHTML="" Width="100%" NumericButtonCount="8">
            </webdiyer:AspNetPager>
        </td>
    </tr>
    <tr>
        <td>
            <asp:Button ID="btnAddBoos" runat="server" Text="添加书籍"  Width="101px" CssClass="Button_Style" PostBackUrl="~/BookManager/AddBook.aspx" /></td>
    </tr>
</table>
