﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Threading;
using System.IO;

public partial class Controls_CreateXML : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;

        DateTime startTime = System.DateTime.Now;
        DateTime endTime = System.DateTime.Now;

        // 根据 ProgressBar.htm 显示进度条界面
        string templateFileName = Path.Combine(Server.MapPath("~/Controls/BookManager/"), "ProgressBar.htm");
        StreamReader reader = new StreamReader(@templateFileName, System.Text.Encoding.GetEncoding("gb2312"));
        string html = reader.ReadToEnd();
        reader.Close();
        Response.Write(html);
        Response.Flush();
        System.Threading.Thread.Sleep(500);

        string jsBlock;
        // 处理完成
        jsBlock = "<script>BeginTrans('开始生成...');</script>";
        Response.Write(jsBlock);
        Response.Flush();

        System.Threading.Thread.Sleep(500);

        // 根据处理任务处理情况更新进度条
        for (int i = 1; i <= 100; i++)
        {
            System.Threading.Thread.Sleep(18);
            jsBlock = "<script>SetPorgressBar('" + i.ToString() + "');</script>";
            Response.Write(jsBlock);
            Response.Flush();
        }

        // 处理完成
        jsBlock = "<script>EndTrans('生成HTML页面成功。');</script>";
        Response.Write(jsBlock);
        Response.Flush();

        // 用时
        endTime = DateTime.Now;
        jsBlock = "<script>SetTimeInfo('用时" + GetTimeSpan(startTime, endTime) + "');</script>";
        Response.Write(jsBlock);
        Response.Flush();

        //自动关闭当前窗体
        for (int a = 2; a >= 0; a--)
        {
            System.Threading.Thread.Sleep(1000);
            string str = "当前页面将于'" + a + "'秒后关闭";
            jsBlock = "<script>CloseWindows('" + "当前页面将于" + a.ToString() + "秒后关闭" + "');</script>";
            Response.Write(jsBlock);
            Response.Flush();

            if (a == 0)
            {
                Response.Write("<script>window.close()</script>");
            }
        }
    
    }
    protected string GetTimeSpan(DateTime startTime, DateTime endTime)
    {
        string timeSpan = string.Empty;
        TimeSpan ts = endTime - startTime;
        if (ts.Days > 0)
            timeSpan += ts.Days.ToString() + "天";
        if (ts.Hours > 0)
            timeSpan += ts.Hours.ToString() + "小时";
        if (ts.Minutes > 0)
            timeSpan += ts.Minutes.ToString() + "分钟";
        if (ts.Seconds > 0)
            timeSpan += ts.Seconds.ToString() + "秒";
        return timeSpan;
    }
}
