﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;

public partial class Controls_EditRecdBook : System.Web.UI.UserControl
{       
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.IRecdBook recdBook = BLLFactory.BusinessLogic.CreateRecdBook();


    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            //获得推荐书籍编号，并保存到ViewState中
            int recdBookId = Convert.ToInt32(Request.QueryString["RecdBookId"].ToString());
            ViewState["RecdBookId"] = recdBookId.ToString();
            bind();
        }
    }
    /// <summary>
    /// 执行页面数据绑定
    /// </summary>
    public void bind()
    {
       int recdBookId=Convert.ToInt32(ViewState["RecdBookId"]);

        //绑定推荐类别到下拉列表
       common.DropDownListBind(ddlRecdBook, "RecdCategoryName", "RecdCategoryId",
       SqlHelper.connectionString, CommandType.StoredProcedure,
       "Tengfei_SelectRecdCategory");

       Model.RecdBook modelRecdBook = new Model.RecdBook();
       modelRecdBook = recdBook.GetRecdBookByRecdBookId(recdBookId);
       //将书籍编号和推荐顺序保存到ViewState中
       ViewState["BookId"] = modelRecdBook.BookId.ToString();
       ViewState["Sort"] = modelRecdBook.Sort.ToString();
       ddlRecdBook.SelectedValue = modelRecdBook.RecdCategoryId.ToString();
        //根据书籍编号查询书籍名称
        string BookName=common.GetBookName(modelRecdBook.BookId);
        txtBookName.Text = BookName;
        txtSort.Text = modelRecdBook.Sort.ToString();
       
    }

    /// <summary>
    /// 保存修改后的推荐书籍信息
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        int BookId=Convert.ToInt32( ViewState["BookId"]);
        int recdBookId=Convert.ToInt32(ViewState["RecdBookId"]);
        Model.RecdBook modelRecdBook = new Model.RecdBook();
        modelRecdBook.BookId = BookId;
        modelRecdBook.RecdBookId = recdBookId;

        int RecdCategoryId = Convert.ToInt32(ddlRecdBook.SelectedValue);
        modelRecdBook.RecdCategoryId = RecdCategoryId;
        int Sort = Convert.ToInt32(txtSort.Text);
        modelRecdBook.RecdCategoryName = ddlRecdBook.SelectedItem.Text;

        //_Sort为修改前推荐书籍的顺序
        int _Sort = Convert.ToInt32(ViewState["Sort"]);

        //如果推荐书籍顺序改变了，则将修改好后的顺序保存到数据库中去
        if (Sort !=_Sort)
        {
            int Num = common.GetSortByRecdCategoryId(RecdCategoryId, Sort);
            if (Num == 0)
            {      
                modelRecdBook.Sort = Sort;
               int IsOK = recdBook.ModifyRecdBook(modelRecdBook);
                if (IsOK > 0)
                {
                    Response.Write("<script>window.close()</script>");
                }
                else
                {
                    Response.Write("<script>alert('修改推荐书籍信息失败!')</script>");
                }
            }
            else
            {
                Response.Write("<Script>alert('该推荐类别中此顺序已存在,请重新输入!')</Script>");
            }
        }
        //如果没有改变顺序，则保持原来的顺序
        else
        {
            modelRecdBook.Sort = _Sort;
            int IsOK = recdBook.ModifyRecdBook(modelRecdBook);
             if (IsOK > 0)
             {
                 Response.Write("<script>window.close()</script>");
             }
             else
             {
                 Response.Write("<script>alert('修改推荐书籍信息失败!')</script>");
             }
        }

    }
}
