﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Data.SqlClient;


public partial class Controls_AddSection : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
    IBLL.ISections sections = BLLFactory.BusinessLogic.CreateSections();
    IBLL.ISystemInfo systemInfo = BLLFactory.BusinessLogic.CreateSystemInfo();

    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            //接受页面传值--章节编号，并保存到ViewState中
            ViewState["SectionId"] = Request.QueryString["SectionId"];
            bind();
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.close()</script>");
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        int SectionId = Convert.ToInt32(ViewState["SectionId"]);
        int StateAudit = Convert.ToInt32(ViewState["StateAudit"]);
        Model.Sections modelSection = new Model.Sections();
        modelSection.SectionTitle = txtSectionTitle.Text.ToString();
        modelSection.SectionId = SectionId;
        //章节审核状态通过触发器执行 
        modelSection.StateAudit = StateAudit;
        modelSection.CharNum = Convert.ToInt32(txtWordCount.Text.ToString());
        modelSection.Contents = FreeTextBox.Text.ToString();
        //获得分类卷编号
        modelSection.VolumeId = Convert.ToInt32(ddlVolumeName.SelectedValue.ToString());
        modelSection.AddTime = DateTime.Now;
        int IsOK = sections.ModifySections(modelSection);
        if (IsOK != 0)
        {
            Response.Write("<Script>alert('修改章节成功!')</Script>");
            Response.Write("<Script>window.close()</Script>");
        }
        else
        {
            Response.Write("<Script>alert('修改章节失败!')</Script>");
        }
    }

    /// <summary>
    /// 绑定控件
    /// </summary>
    public void bind()
    {
        //查询是否自动审核书籍，自动生成HTML
        int AutoHTML = common.GetAutomatismHTML();
        int AutoAudit = common.GetAutomatismAuditingBook();
        if (AutoAudit == 0)
        {
            lblAutoAudit.Text = "×";
            lblAutoAudit.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            lblAutoAudit.Text = "√";
            lblAutoAudit.ForeColor = System.Drawing.Color.Blue;
        }
        if (AutoHTML == 0)
        {
            lblAutoHtml.Text = "×";
            lblAutoHtml.ForeColor = System.Drawing.Color.Red;
        }
        else
        {
            lblAutoHtml.Text = "√";
            lblAutoHtml.ForeColor = System.Drawing.Color.Blue;
        }

        //创建Model层Sections对象
        Model.Sections modelSection = new Model.Sections();
        int SectionId = Convert.ToInt32(ViewState["SectionId"]);
        modelSection=sections.GetSectionsById(SectionId);
        txtSectionTitle.Text = modelSection.SectionTitle.ToString();
        txtWordCount.Text = modelSection.CharNum.ToString();
        FreeTextBox.Text = modelSection.Contents.ToString();
        //保存书籍的审核状态
        ViewState["StateAudit"] = modelSection.StateAudit.ToString();

        //保存书籍分类卷编号
        ViewState["VolumeId"] = modelSection.VolumeId.ToString();
        ddlVolumeName.SelectedValue = ViewState["VolumeId"].ToString();
        //查询是否书籍为自动审核
        int AutomatismAuditingBook = common.GetAutomatismAuditingBook();
        Model.SystemInfo modelSystem = new Model.SystemInfo();
        modelSystem = systemInfo.GetAllSystemInfo();
        int VolumeId = Convert.ToInt32(ViewState["VolumeId"]);
        int BookId = common.GetBookIdByVolumeId(VolumeId);


        //绑定分类卷信息到下拉列表
        SqlParameter parm = new SqlParameter("@BookId", SqlDbType.Int);
        parm.Value = BookId;
        common.DropDownListBind(ddlVolumeName, "VolumeName", "VolumeId",
              SqlHelper.connectionString, CommandType.StoredProcedure,
              "Tengfei_SelectAllVolumeByBookId", parm);

    }

}
