﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_RecdBookInfo : System.Web.UI.UserControl
{
    IBLL.IRecdBook recdBook = BLLFactory.BusinessLogic.CreateRecdBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        //判断Session["UserName"]是否为空，如果为空则跳转到登陆页面
        if (Session["UserName"] != null)
        {
            //判断用户的类型
            string userName = Session["UserName"].ToString(); ;
            ProfileCommon p = Profile.GetProfile(userName);
            string authorityName = common.GetAuthorityName(p.Rating);
            ViewState["AuthorityName"] = authorityName;
            if (!IsPostBack)
            {
                if (authorityName == "系统管理员")
                {
                    bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }

            }
        }
        else
        {
            Response.Redirect("~/Clientele/Login.aspx");
        }
    }
    /// <summary>
    /// 跳转页面后执行分页控件页面值改变事件
    /// </summary>
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
            Pager.CurrentPageIndex = e.NewPageIndex;
            bind();      
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    /// <summary>
    /// 绑定数据到GridView
    /// </summary>
    public void bind()
    {
        //如果传推荐类别ID过来，则显示该推荐类别下所有推荐书籍
        if (Request.QueryString["Id"] != null)
        {
            int RecdCategoryId = Convert.ToInt32(Request.QueryString["Id"]);
            Pager.RecordCount = common.GetRecdBookCountById(RecdCategoryId);
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.RecdBook> modelRecdBook = recdBook.GetRecdBookById(RecdCategoryId,paper);
            GVRecdBookList.DataSource = modelRecdBook;
            GVRecdBookList.DataBind();
        }
        //如果没有传值过来，则显示所有推荐书籍信息
        else
        {
            Pager.RecordCount = common.GetAllRecdBookCount();
            Model.PagerParameter paper = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.RecdBook> modelRecdBook = recdBook.GetRecdBook(paper);
            GVRecdBookList.DataSource = modelRecdBook;
            GVRecdBookList.DataBind();
        }
            //自定义信息显示
            Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
      
    }
    /// <summary>
    /// 根据推荐类别ID查询推荐类别名称
    /// </summary>
    /// <param name="RecdCategoryId">推荐类别ID</param>
    /// <returns>返回推荐类别名称</returns>
    public string  getRecdCategoryName( int RecdCategoryId)
    {
        string RecdCategoryName = common.GetRecdCategoryNameByRecdCategoryId(RecdCategoryId);
        return RecdCategoryName;
    }
    /// <summary>
    /// 根据书籍编号查询书籍名称
    /// </summary>
    /// <param name="BookId">书籍编号</param>
    /// <returns>返回书籍名称</returns>
    public string getBookNameById(int BookId)
    {
        string BookName = common.GetBookName(BookId);
        return BookName;
    }

    //删除推荐书籍操作
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int recdBookId = Convert.ToInt32(e.CommandArgument);
        int IsOK = recdBook.RemoveRecdBook(recdBookId);
        if (IsOK > 0)
        {
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 书籍删除失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }
}
