﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class Controls_BookManager_UpLoadImages : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {

        }
    }
    protected void btnUpLoad_Click(object sender, EventArgs e)
    {
        //获得选中的文件类型
        string ImageType = flpImages.PostedFile.ContentType;
        Boolean fileOk = false;

        //判断是否已经选取文件
        if (flpImages.HasFile)
        {


            //取得文件的扩展名,并转换成小写
            string fileExtension = System.IO.Path.GetExtension(flpImages.FileName).ToLower();
            //限定只能上传jpg和gif图片
            string[] allowExtension = { ".jpg", ".gif" };
            //对上传的文件的类型进行一个个匹对，只允许类型为.jpg,.gif
            for (int i = 0; i < allowExtension.Length; i++)
            {
                if (fileExtension == allowExtension[i])
                {
                    fileOk = true;
                    break;
                }
            }
            //最后的结果
            if (fileOk)
            {
                if (Session["UserName"] != null)
                {
                    try
                    {
                        //获得文件的路径
                        string URL = flpImages.PostedFile.FileName;
                        string ImageNames = URL.Substring(URL.LastIndexOf("\\") + 1);
                        //获得上传书籍封面的URL(相对路径)
                        string PhotoPath = ConfigurationManager.AppSettings["PhotoPath"].ToString();

                        //将上传路径转换为绝对路径
                        string path = Server.MapPath(PhotoPath);
                        string time = DateTime.Now.TimeOfDay.Seconds.ToString()+DateTime.Now.TimeOfDay.Milliseconds.ToString();
                        string UserName = Session["UserName"].ToString();
                        //对保存的文件名经行标示,以确定书籍封面名的唯一性
                        string saveName = UserName + time + ImageNames;
                        //上传图片到指定文件夹  
                        flpImages.PostedFile.SaveAs(path + saveName);
                        Session["BookImage"] = PhotoPath + saveName;

                        Response.Write("<script type='text/javascript'>window.returnValue='" + saveName + "'</script>");
                        Response.Write("<script type='text/javascript'>window.alert('上传图片成功')</script>");
                        Response.Write("<script type='text/javascript'>window.close()</script>");
                    }
                    catch
                    {
                        Response.Write("<script type='text/javascript'>window.alert('上传图片失败')</script>");
                    }
                }
                else {
                    Response.Redirect("~/Clientele/Login.aspx");
                }
            }
            else
            {
                Response.Write("<script type='text/javascript'>window.alert('图片类型错误!')</script>");
            }




        }
        else
        {
            Response.Write("<script>alert('请选择要上传的图片')</script>");
        }

    }

        
} 
