﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_BookManager_WaitAudit : System.Web.UI.UserControl
{
    /// <summary>
    /// 动态创建接口实例
    /// </summary>
     IBLL.ISections sections = BLLFactory.BusinessLogic.CreateSections();

    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");

        //判断Session["UserName"]是否为空，如果为空则跳转到登陆页面
        if (Session["UserName"] != null)
        {
            //判断用户的类型
            string userName = Session["UserName"].ToString(); ;
            ProfileCommon p = Profile.GetProfile(userName);
            string AuthorityName = common.GetAuthorityName(p.Rating);
            ViewState["AuthorityName"] = AuthorityName;
            if (!IsPostBack)
            {
                if (AuthorityName == "系统管理员")
                {
                    bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
        }
        else
        {
            Response.Redirect("~/Clientele/Login.aspx");
        }
    }

    /// <summary>
    /// 绑定未审核章节信息到GridView中去，并绑定分页控件
    /// </summary>
    public void bind()
    {
        if (ViewState["AuthorityName"].ToString() == "系统管理员")
        {
            int StateAudit = 0;
            Pager.RecordCount = common.GetSectionCountByStateAudit(StateAudit);
            Model.PagerParameter modelPagerParameter = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            IList<Model.Sections> modelSections = sections.GetSectionsByStateAudit(StateAudit, modelPagerParameter);
            gvSectionInfo.DataSource = modelSections;
            gvSectionInfo.DataBind();

        }
        //自定义信息显示
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 分页控件的页面值发生改变时触发此事件
    /// </summary>
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        bind();
    }

    /// <summary>
    /// 根据分类卷编号查询分类卷名称
    /// </summary>
    /// <param name="VolumeId">分类卷编号</param>
    /// <returns>返回分类卷名称</returns>
    public string GetVolumeName(int VolumeId)
    {
        string VolumeName = common.GetVolumeName(VolumeId);
        return VolumeName;
    }

    protected void gvSectionInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    /// <summary>
    /// 根据审核状态返回相应的样式
    /// </summary>
    /// <param name="StateAudit">审核状态</param>
    /// <returns>返回Lable样式</returns>
    public string GetText(int StateAudit)
    {
        if(StateAudit==0)
        {
            return "×";
        }
        else
        {
            return "√";
        }
    }
    public System.Drawing.Color GetColor(int StateAudit)
    {
        if (StateAudit == 0)
        {
            return System.Drawing.Color.Red;
        }
        else
        {
            return System.Drawing.Color.Blue;
        }
    }

    /// <summary>
    /// 审核分类卷操作
    /// </summary>
    protected void lbtnAudit_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int StateAudit = 1;
        int IsOK = common.SetSectionAuthorized(SectionId, StateAudit);
        if (IsOK != 0)
        {
           
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:+\n 章节审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        } 

    }
    /// <summary>
    /// 撤销分类卷操作
    /// </summary>
    protected void lbtnD_Audit_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int StateAudit = 0;
        int IsOK = common.SetSectionAuthorized(SectionId, StateAudit);
        if (IsOK != 0)
        {
      
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 章节撤销审核失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }

    /// <summary>
    /// 删除分类卷操作
    /// </summary>
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int SectionId = Convert.ToInt32(e.CommandArgument);
        int IsOK = common.DeleteSection(SectionId);
        if (IsOK != 0)
        {
       
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
        else
        {
            Response.Write("<script>alert('系统提示:'+\n' 章节删除失败!')</script>");
            Response.Write("<script>window.location.href = window.location.href</script>");
        }
    }
  
}
