﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Windows.Forms;
using System.Collections.Generic;
using System.IO;
using System.Text;
using DBUtility;


public partial class Controls_Category : System.Web.UI.UserControl
{
    /// <summary>
    /// 调用接口实现
    /// 调用IBLL.ICategoryManager接口
    /// </summary>
    IBLL.ICategoryManager categoryManager = BLLFactory.BusinessLogic.CreateCategoryManager();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;
        if (!Page.IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    //获得树节点id,如果id不为空绑定CatBind()方法,否则绑定JuniorBind()方法
                    if (Request["id"] != null)
                    {
                        //获得树节点id,绑定CatBind()方法(上级目录)
                        int id = int.Parse(Request["id"]);
                        CatBind(id);
                    }
                    else
                    {
                        //调用GetCategoryCountBySuperiorId()方法
                        //并跟据上级目录id(superiorId)查找出所有上级目录信息
                        pager.RecordCount = categoryManager.GetCategoryCountBySuperiorId(int.Parse(Request["superiorId"]));
                        //获得上级目录id(superiorId),绑定JuniorBind()方法(下级目录)
                        //通过上级目录id(superiorId),得到相应的下级目录
                        JuniorBind(int.Parse(Request["superiorId"]));
                    }
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
        }
    } 

    /// <summary>
    /// 上级目录
    /// 通过CatBind()方法,绑定GridView
    /// </summary>
    /// <param name="id">树节点id</param>
    protected void CatBind(int id)
    {
        //调用GetCategoryCountBySuperiorId()方法
        pager.RecordCount = categoryManager.GetCategoryCountBySuperiorId(int.Parse(Request["id"]));
        //声明PagerParameter对象,实现分页功能
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        //声明CategoryManager对象
        //通过GetCategoryBySuperiorId()方法查寻类别信息
        //将CategoryManager对象当数据源,绑定GridView
        IList<Model.CategoryManager> modelCategoryManager = categoryManager.GetCategoryBySuperiorId(id, pagers);
        gvBind.DataSource = modelCategoryManager;
        gvBind.DataBind(); 
        //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }
     
    /// <summary>
    /// 实现分页
    /// </summary>
    /// <param name="src"></param>
    /// <param name="e"></param>
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        //实现分页
        pager.CurrentPageIndex = e.NewPageIndex;
        //获得树节点id,如果id不为空绑定CatBind()方法,否则绑定JuniorBind()方法
        if (Request["id"] != null)
        {
            CatBind(int.Parse(Request["id"]));
        }
        else
        {
            JuniorBind(int.Parse(Request["superiorId"]));
        }
    }

    /// <summary>
    /// 删除数据
    /// 从客户端传入ID
    /// 通过ID来删除数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lkbtnDelete_Command(object sender, CommandEventArgs e)
    {
        //获得客户端传来的ID
        int iid = Convert.ToInt32(e.CommandArgument);
        //调用RemoveCategory()方法来实现删除功能,通过id来删除
        categoryManager.RemoveCategory(iid);
        //删除完毕重新绑定GridView
        //获得树节点id,如果id不为空绑定CatBind()方法,否则绑定JuniorBind()方法
        if (Request["id"] != null)
        {
            CatBind(int.Parse(Request["id"]));
        }
        else
        {
            JuniorBind(int.Parse(Request["superiorId"]));
        }
    }
 
    /// <summary>
    /// 下级目录
    /// </summary>
    /// <param name="superiorId">上级目录ID</param>
    protected void JuniorBind(int superiorId)
    {
        //声明PagerParameter对象,实现分页功能
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        //声明CategoryManager对象
        //通过GetCategoryBySuperiorId()方法查寻类别信息
        //将CategoryManager对象当数据源,绑定GridView
        IList<Model.CategoryManager> modelCategoryManager = categoryManager.GetCategoryBySuperiorId(superiorId, pagers);
        gvBind.DataSource = modelCategoryManager;
        gvBind.DataBind(); //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// GetCategoryManagerById()方法是把上级目录superiorId
    /// 转换成相应显示的categoryName
    /// 显示在客户端
    /// 这个方法在客户端源码中调用
    /// </summary>
    /// <param name="superiorId">上级目录ID</param>
    /// <returns>返回CategoryManger的CategoryName</returns>
    public string GetCategoryManagerById(int superiorId)
    {
        //common.GetCategoryManager()方法通过获得superiorId,将显示ID转换成相应的字段
        string CategoryManager = common.GetCategoryManager(superiorId);
        return CategoryManager;
    }

    /// <summary>
    /// GetRequest()方法用于客户端传值
    /// </summary>
    /// <returns></returns>
    public string GetRequest()
    {
        if (Request["id"] != null)
        {
            return Request["id"].ToString();
        }
        else if (Request["SuperiorId"] != null)
        {
            return Request["SuperiorId"].ToString();
        }
        else
        {
            return "1";
        }
    }
    
    /// <summary>
    /// 鼠标移动事件
    /// 鼠标放在GridView相应的行上面变色,离开时变回原色
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void gvBind_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }

    /// <summary>
    /// 导出Excel
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnExcel_Click(object sender, EventArgs e)
    {
        //重新绑定GridView
        if (Request["id"] != null)
        {
            CatBind(int.Parse(Request["id"]));
        }
        else
        {
            JuniorBind(int.Parse(Request["superiorId"]));
        }
        //输出流格试
        Response.ContentType = "application/vnd.ms-Excel";
        //弹出提示框（提示打开，保存，取消）
        Response.AddHeader("Content-Disposition", "inline;filename=" + HttpUtility.UrlEncode("Excel.xls", Encoding.UTF8));
    }
}
