﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;

public partial class Controls_Client_BookInfo : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    IBLL.IFavouriteBook favBook = BLLFactory.BusinessLogic.CreateFavouriteBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["bookId"] != null)
            {
                ViewState["bookId"] = Request["bookId"].ToString();
                BindBookInfo();
            }
            
        }
    }
    public void BindBookInfo()
    {
        if (ViewState["bookId"] != null)
        {
            Model.Book bookInfo = book.GetBookById(Convert.ToInt32(ViewState["bookId"]));
            ArrayList arr = new ArrayList();
            arr.Add(bookInfo);
            fvBookInfo.DataSource = arr;
            fvBookInfo.DataBind();
        }
    }
    public string GetCategory(int categoryId)
    {
       return common.GetCategoryName(categoryId);
    }

    protected void btnRead_Click(object sender, ImageClickEventArgs e)
    {
        if (ViewState["bookId"] != null)
        {
            book.TotalClick(Convert.ToInt32(ViewState["bookId"]));
            Response.Redirect("Volume.aspx?bookId=" + ViewState["bookId"].ToString());
        }
    }
    protected void btnRecdBook_Click(object sender, ImageClickEventArgs e)
    {
        if (ViewState["bookId"] != null)
        {
            int val=book.RecdNum(Convert.ToInt32(ViewState["bookId"]));
            if (val > 0)
            {
                Response.Write("<script>alert('推荐书籍成功！');location='BookInfo.aspx?bookId="+ViewState["bookId"]+"'</script>");
            }
        }
    }
    protected void btnCollect_Click(object sender, ImageClickEventArgs e)
    {
        if (ViewState["bookId"] != null)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                int bookCount = common.GetFovBookCount(p.MemberGroup);
                int haveBookCount = common.GetBookCountByUser(Session["UserName"].ToString());
                if (haveBookCount < bookCount)
                {
                    int val = favBook.ValidateFavouriteBook(Session["UserName"].ToString(), Convert.ToInt32(ViewState["bookId"]));
                    if (val > 0)
                    {
                        Response.Write("<script>alert('藏书架中已收藏了此书，不能重复收藏了！');location='BookInfo.aspx?bookId=" + ViewState["bookId"] + "'</script>");
                    }
                    else
                    {
                        Model.FavouriteBook fb = new Model.FavouriteBook(0, Convert.ToInt32(ViewState["bookId"]), Session["UserName"].ToString());
                        int val1 = favBook.AddFavouriteBook(fb);
                        if (val1 > 0)
                        {
                            int val2 = book.CollectionNum(Convert.ToInt32(ViewState["bookId"]));
                            Response.Write("<script>alert('收藏书籍成功！');location='FavouriteBook.aspx'</script>");
                        }
                    }
                }
                else
                {
                    Response.Write("<script>alert('您所属的会员组藏书架已满，请升级后再藏书！');location='BookInfo.aspx?bookId=" + ViewState["bookId"] + "'</script>");
                }
            }
            else
            {
                Response.Write("<script>alert('收藏书籍请必须先登陆.');location='Login.aspx'</script>");
            }
        }
    }
}
