﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;

public partial class Controls_Client_Compositor : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["totalClick"] != null)
            {
                TotalClickBind();
            }
            else if (Request["totalRecd"] != null)
            {
                TotalRecdBind();
            }
            else if (Request["totalcollect"] != null)
            {
                TotalcollectionBind();
            }
            else
            {
                TotalClickBind();
            }
        }
    }
    public void TotalClickBind()
    {
        IList<Model.Book> bookSource = book.GetTotalClickSort();
        gvCompositor.DataSource = bookSource;
        gvCompositor.DataBind();
    }
    public void TotalRecdBind()
    {
        IList<Model.Book> bookSource = book.GetTotalRecdSort();
        gvCompositor.DataSource = bookSource;
        gvCompositor.DataBind();
    }
    public void TotalcollectionBind()
    {
        IList<Model.Book> bookSource = book.GetTotalCollecSort();
        gvCompositor.DataSource = bookSource;
        gvCompositor.DataBind();
    }
    public string GetCategoryName(int categoryId)
    {
        return common.GetCategoryName(categoryId);
    }
    protected void gvCompositor_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Cells[0].Style.Add("color", "Fuchsia");
            e.Row.Cells[5].Style.Add("color","red");
            e.Row.Cells[6].Style.Add("color","blue");
            e.Row.Cells[7].Style.Add("color","green");
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
        if (e.Row.RowIndex != -1)
        {
            int id=e.Row.RowIndex+1;
            e.Row.Cells[0].Text = id.ToString();
        }
    }
}
