﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Model;
using DBUtility;

public partial class Controls_Client_FavouriteBook : System.Web.UI.UserControl
{
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    IBLL.IFavouriteBook favBook = BLLFactory.BusinessLogic.CreateFavouriteBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ViewState["UserName"] = Session["UserName"].ToString();
                FavouriteBookBind();
            }
        }
    }
    public void FavouriteBookBind()
    {
        if (ViewState["UserName"] != null)
        {
            Pager.RecordCount = favBook.GetFavouriteBookCount(ViewState["UserName"].ToString());
            PagerParameter pager = new PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
            gvFavouriteBook.DataSource = book.GetFavouriteBookByUser(ViewState["UserName"].ToString(), pager);
            gvFavouriteBook.DataBind();
            Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
            Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
        }
        else
        {
            Response.Write("Login.aspx");
        }
    }
    public string GetBookCategory(int categoryId)
    {
        return common.GetCategoryName(categoryId);
    }
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(gvFavouriteBook.DataKeys[e.RowIndex].Value);
        favBook.RemoveFavouriteBook(id);
        FavouriteBookBind();  
    }
    protected void gvFavouriteBook_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            e.Row.Attributes.Add("onmouseout","this.style.backgroundColor=c");
        }
    }
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        FavouriteBookBind();
    }
}
