﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_Client_SectionToday : System.Web.UI.UserControl
{
    IBLL.ISections sec = BLLFactory.BusinessLogic.CreateSections();
    IBLL.IBook book = BLLFactory.BusinessLogic.CreateBook();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request["more"] != null)
            {
                SectionTodayBind();
            }
            else
            {
                SectionTodayTopBind();
            }
        }
    }
    public void SectionTodayBind()
    { 
        string startTime = DateTime.Today.ToShortDateString() + " 00:00:00";
        string endTime = DateTime.Today.ToShortDateString() + " 23:59:59";
        IList<Model.Sections> secSource = sec.GetSectionsToday(startTime, endTime);
        dltSectionToday.DataSource = secSource;
        dltSectionToday.DataBind();
    }
    public void SectionTodayTopBind()
    {
        string startTime = DateTime.Today.ToShortDateString() + " 00:00:00";
        string endTime = DateTime.Today.ToShortDateString() + " 23:59:59";
        IList<Model.Sections> secSource = sec.GetSectionsTodayTop(startTime, endTime, 20);
        dltSectionToday.DataSource = secSource;
        dltSectionToday.DataBind();
    }
    public string GetShortDateString(DateTime addTime)
    {
        string s = addTime.ToString();
        int t1 = s.IndexOf(' ');
        int t2 = s.LastIndexOf(':');
        return s.Substring(t1+1, t2-t1-1);
    }
    public string GetBookName(int volumeId)
    {
        return book.GetBookName(volumeId);
    }
}
