﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;

public partial class Controls_Client_Upgrade : System.Web.UI.UserControl
{
    IBLL.IMemberGroup m = BLLFactory.BusinessLogic.CreateMemberGroup();
    int flag = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["UserName"] != null)
        {
            ViewState["UserName"] = Session["UserName"].ToString();
            Bind();
        }
    }
    public void Bind()
    {
        fvUpgrade.DataSource = Upgrade();
        fvUpgrade.DataBind();
    }
    public DataTable Upgrade()
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("Score",Type.GetType("System.String"));
        dt.Columns.Add("MemberGroupId", Type.GetType("System.Int32"));
        dt.Columns.Add("MemberGroup",Type.GetType("System.String"));
        dt.Columns.Add("UpgradeScore",Type.GetType("System.String"));
        dt.Columns.Add("UpgradeMemberGroupId", Type.GetType("System.Int32"));
        dt.Columns.Add("UpgradeMemberGroup",Type.GetType("System.String"));
        if (ViewState["UserName"] != null)
        {
            ProfileCommon p = Profile.GetProfile(ViewState["UserName"].ToString());
            Model.MemberGroup mg = m.GetNextMemberGroupById(p.MemberGroup);
            DataRow dr = dt.NewRow();
            dr[0] = p.Score.ToString();
            dr[1] = p.MemberGroup;
            dr[2] = common.GetMemberGroupName(p.MemberGroup);
            if (mg != null)
            {
                dr[3] = mg.PromoteScore.ToString();
                dr[4] = mg.MemberGroupId;
                dr[5] = mg.MemberGroupName;
                flag = 1;
            }
            else
            {
                dr[3] ="暂无下一等级，请等待系统管理员添加。";
                dr[4] = 0;
                dr[5] = "暂无下一等级，请等待系统管理员添加。";
            }
            dt.Rows.Add(dr);
            dt.AcceptChanges();
        }
        return dt;
    }
    protected void btnUpgrade_Click(object sender, EventArgs e)
    {
        DataTable dt = Upgrade();
        if (flag == 1)
        {
            int score = Convert.ToInt32(dt.Rows[0][0]);
            int UpgradeScore = Convert.ToInt32(dt.Rows[0][3]);
            int UpgradeMemberGroupId = Convert.ToInt32(dt.Rows[0][4]);
            if (score < UpgradeScore)
            {
                Response.Write("<script>alert('对不起，您的积分不够。');</script>");
            }
            else
            {
                if (ViewState["UserName"] != null)
                {
                    ProfileCommon p = Profile.GetProfile(ViewState["UserName"].ToString());
                    p.Score = p.Score - UpgradeScore;
                    p.MemberGroup = UpgradeMemberGroupId;
                    p.Save();
                    Response.Write("<script>alert('恭喜您，升级成功！');</script>");
                    Bind();
                }
                else
                {
                    Server.Transfer("Login.aspx");
                }
            }
        }
        else
        {
            Response.Write("<script>alert('对不起，暂无下一等级。');location='Upgrade.aspx'</script>");
        }

    }
}
